/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationImageServer;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.collections15.Transformer;
import org.opennms.netmgt.bsm.service.AlarmProvider;
import org.opennms.netmgt.bsm.service.BusinessServiceStateChangeHandler;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.StatusWithIndex;
import org.opennms.netmgt.bsm.service.model.StatusWithIndices;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.functions.reduce.Threshold;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ThresholdResultExplanation;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.service.model.graph.internal.BusinessServiceGraphImpl;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphAlgorithms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultBusinessServiceStateMachine
implements BusinessServiceStateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBusinessServiceStateMachine.class);
    public static final Status MIN_SEVERITY = Status.NORMAL;
    @Autowired
    private AlarmProvider m_alarmProvider;
    private final List<BusinessServiceStateChangeHandler> m_handlers = Lists.newArrayList();
    private final ReadWriteLock m_rwLock = new ReentrantReadWriteLock();
    private BusinessServiceGraph m_g = new BusinessServiceGraphImpl(Collections.emptyList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusinessServices(List<BusinessService> businessServices) {
        this.m_rwLock.writeLock().lock();
        try {
            BusinessServiceGraphImpl g = new BusinessServiceGraphImpl(businessServices);
            HashSet reductionsKeysToLookup = Sets.newHashSet();
            for (String reductionKey : g.getReductionKeys()) {
                GraphVertex reductionKeyVertex = this.m_g.getVertexByReductionKey(reductionKey);
                if (reductionKeyVertex != null) {
                    this.updateAndPropagateVertex((BusinessServiceGraph)g, g.getVertexByReductionKey(reductionKey), reductionKeyVertex.getStatus());
                    continue;
                }
                reductionsKeysToLookup.add(reductionKey);
            }
            if (this.m_alarmProvider == null && reductionsKeysToLookup.size() > 0) {
                LOG.warn("There are one or more reduction keys to lookup, but no alarm provider is set.");
            } else {
                for (String reductionKey : reductionsKeysToLookup) {
                    AlarmWrapper alarm = this.m_alarmProvider.lookup(reductionKey);
                    if (alarm == null) continue;
                    this.updateAndPropagateVertex((BusinessServiceGraph)g, g.getVertexByReductionKey(reductionKey), alarm.getStatus());
                }
            }
            this.m_g = g;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    public void handleNewOrUpdatedAlarm(AlarmWrapper alarm) {
        this.m_rwLock.writeLock().lock();
        try {
            this.updateAndPropagateVertex(this.m_g, this.m_g.getVertexByReductionKey(alarm.getReductionKey()), alarm.getStatus());
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    private void updateAndPropagateVertex(BusinessServiceGraph graph, GraphVertex vertex, Status newStatus) {
        if (vertex == null) {
            return;
        }
        newStatus = newStatus.isLessThan(MIN_SEVERITY) ? MIN_SEVERITY : newStatus;
        Status previousStatus = vertex.getStatus();
        if (previousStatus.equals((Object)newStatus)) {
            return;
        }
        vertex.setStatus(newStatus);
        this.onStatusUpdated(graph, vertex, previousStatus);
        ArrayList updatedEges = Lists.newArrayList();
        for (GraphEdge edge : graph.getInEdges((Object)vertex)) {
            Status mappedStatus = newStatus;
            mappedStatus = newStatus.isGreaterThan(MIN_SEVERITY) ? edge.getMapFunction().map(newStatus).orElse(MIN_SEVERITY) : newStatus;
            if (mappedStatus.equals((Object)edge.getStatus())) continue;
            edge.setStatus(mappedStatus);
            updatedEges.add(edge);
        }
        for (GraphEdge edge : updatedEges) {
            this.reduceUpdateAndPropagateVertex(graph, (GraphVertex)graph.getOpposite((Object)vertex, (Object)edge));
        }
    }

    private void reduceUpdateAndPropagateVertex(BusinessServiceGraph graph, GraphVertex vertex) {
        if (vertex == null) {
            return;
        }
        List<StatusWithIndex> statuses = DefaultBusinessServiceStateMachine.weighEdges(graph.getOutEdges((Object)vertex));
        Optional reducedStatus = vertex.getReductionFunction().reduce(statuses);
        Status newStatus = reducedStatus.isPresent() ? ((StatusWithIndices)reducedStatus.get()).getStatus() : MIN_SEVERITY;
        this.updateAndPropagateVertex(graph, vertex, newStatus);
    }

    public static List<StatusWithIndex> weighEdges(Collection<GraphEdge> edges) {
        return DefaultBusinessServiceStateMachine.weighStatuses(edges.stream().collect(Collectors.toMap(Function.identity(), e -> e.getStatus(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new)));
    }

    public static List<StatusWithIndex> weighStatuses(Map<GraphEdge, Status> edgesWithStatus) {
        int gcd = edgesWithStatus.keySet().stream().map(e -> e.getWeight()).reduce((a, b) -> BigInteger.valueOf(a.intValue()).gcd(BigInteger.valueOf(b.intValue())).intValue()).orElse(1);
        ArrayList statuses = Lists.newArrayList();
        int k = 0;
        for (Map.Entry<GraphEdge, Status> entry : edgesWithStatus.entrySet()) {
            int relativeWeight = Math.floorDiv(entry.getKey().getWeight(), gcd);
            for (int i = 0; i < relativeWeight; ++i) {
                statuses.add(new StatusWithIndex(entry.getValue(), k));
            }
            ++k;
        }
        return statuses;
    }

    private void onStatusUpdated(BusinessServiceGraph graph, GraphVertex vertex, Status previousStatus) {
        GraphVertex previousVertex;
        BusinessService businessService = vertex.getBusinessService();
        if (businessService == null) {
            return;
        }
        if (graph != this.m_g && (previousVertex = this.m_g.getVertexByBusinessServiceId(businessService.getId())) != null && vertex.getStatus().equals((Object)previousVertex.getStatus())) {
            return;
        }
        for (BusinessServiceStateChangeHandler handler : this.m_handlers) {
            handler.handleBusinessServiceStateChanged(businessService, vertex.getStatus(), previousStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getOperationalStatus(BusinessService businessService) {
        Objects.requireNonNull(businessService);
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByBusinessServiceId(businessService.getId());
            if (vertex != null) {
                Status status = vertex.getStatus();
                return status;
            }
            Status status = null;
            return status;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getOperationalStatus(IpService ipService) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByIpServiceId(Integer.valueOf(ipService.getId()));
            if (vertex != null) {
                Status status = vertex.getStatus();
                return status;
            }
            Status status = null;
            return status;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getOperationalStatus(String reductionKey) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByReductionKey(reductionKey);
            if (vertex != null) {
                Status status = vertex.getStatus();
                return status;
            }
            Status status = null;
            return status;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getOperationalStatus(Edge edge) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByEdgeId(edge.getId());
            if (vertex != null) {
                Status status = vertex.getStatus();
                return status;
            }
            Status status = null;
            return status;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    public void setAlarmProvider(AlarmProvider alarmProvider) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_alarmProvider = alarmProvider;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    public void addHandler(BusinessServiceStateChangeHandler handler, Map<String, String> attributes) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_handlers.add(handler);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandler(BusinessServiceStateChangeHandler handler, Map<String, String> attributes) {
        this.m_rwLock.writeLock().lock();
        try {
            boolean bl = this.m_handlers.remove(handler);
            return bl;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderGraphToPng(File tempFile) {
        this.m_rwLock.readLock().lock();
        try {
            KKLayout layout = new KKLayout((Graph)this.m_g);
            layout.setSize(new Dimension(1024, 1024));
            VisualizationImageServer vv = new VisualizationImageServer((Layout)layout, layout.getSize());
            vv.setPreferredSize(new Dimension(1200, 1200));
            vv.getRenderContext().setVertexLabelTransformer((Transformer)new Transformer<GraphVertex, String>(){

                public String transform(GraphVertex vertex) {
                    if (vertex.getBusinessService() != null) {
                        return String.format("BS[%s]", vertex.getBusinessService().getName());
                    }
                    if (vertex.getIpService() != null) {
                        IpService ipService = vertex.getIpService();
                        return String.format("IP_SERVICE[%s,%s]", ipService.getId(), ipService.getServiceName());
                    }
                    if (vertex.getReductionKey() != null) {
                        return String.format("RK[%s]", vertex.getReductionKey());
                    }
                    return "UNKNOWN";
                }
            });
            vv.getRenderContext().setEdgeLabelTransformer((Transformer)new Transformer<GraphEdge, String>(){

                public String transform(GraphEdge edge) {
                    return String.format("%s", edge.getMapFunction().getClass().getSimpleName());
                }
            });
            BufferedImage image = (BufferedImage)vv.getImage((Point2D)new Point2D.Double(vv.getGraphLayout().getSize().getWidth() / 2.0, vv.getGraphLayout().getSize().getHeight() / 2.0), new Dimension(vv.getGraphLayout().getSize()));
            try {
                ImageIO.write((RenderedImage)image, "png", tempFile);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    public BusinessServiceGraph getGraph() {
        return this.m_g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GraphEdge> calculateImpacting(BusinessService businessService) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByBusinessServiceId(businessService.getId());
            Set set = GraphAlgorithms.calculateImpacting((BusinessServiceGraph)this.m_g, (GraphVertex)vertex);
            return set;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessServiceStateMachine clone(boolean preserveState) {
        this.m_rwLock.readLock().lock();
        try {
            DefaultBusinessServiceStateMachine sm = new DefaultBusinessServiceStateMachine();
            BusinessServiceGraph graph = this.getGraph();
            sm.setBusinessServices(graph.getVertices().stream().filter(v -> v.getBusinessService() != null).map(v -> v.getBusinessService()).collect(Collectors.toList()));
            if (preserveState) {
                for (final String reductionKey : graph.getReductionKeys()) {
                    final GraphVertex reductionKeyVertex = graph.getVertexByReductionKey(reductionKey);
                    sm.handleNewOrUpdatedAlarm(new AlarmWrapper(){

                        public String getReductionKey() {
                            return reductionKey;
                        }

                        public Status getStatus() {
                            return reductionKeyVertex.getStatus();
                        }

                        public Integer getId() {
                            return 0;
                        }
                    });
                }
            }
            DefaultBusinessServiceStateMachine defaultBusinessServiceStateMachine = sm;
            return defaultBusinessServiceStateMachine;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphVertex> calculateRootCause(BusinessService businessService) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByBusinessServiceId(businessService.getId());
            List list = GraphAlgorithms.calculateRootCause((BusinessServiceGraph)this.m_g, (GraphVertex)vertex);
            return list;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphVertex> calculateImpact(BusinessService businessService) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByBusinessServiceId(businessService.getId());
            List<GraphVertex> list = this.calculateImpact(vertex);
            return list;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphVertex> calculateImpact(IpService ipService) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByIpServiceId(Integer.valueOf(ipService.getId()));
            List<GraphVertex> list = this.calculateImpact(vertex);
            return list;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphVertex> calculateImpact(String reductionKey) {
        this.m_rwLock.readLock().lock();
        try {
            GraphVertex vertex = this.m_g.getVertexByReductionKey(reductionKey);
            List<GraphVertex> list = this.calculateImpact(vertex);
            return list;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    public ThresholdResultExplanation explain(BusinessService businessService, Threshold threshold) {
        GraphVertex vertex = this.getGraph().getVertexByBusinessServiceId(businessService.getId());
        List<StatusWithIndex> statusesWithIndices = DefaultBusinessServiceStateMachine.weighEdges(this.getGraph().getOutEdges((Object)vertex));
        List statuses = statusesWithIndices.stream().map(si -> si.getStatus()).collect(Collectors.toList());
        Status reducedStatus = threshold.reduce(statusesWithIndices).orElse(new StatusWithIndices(MIN_SEVERITY, Collections.emptyList())).getStatus();
        ThresholdResultExplanation explanation = new ThresholdResultExplanation();
        explanation.setStatus(reducedStatus);
        explanation.setHitsByStatus(threshold.getHitsByStatus(statuses));
        explanation.setGraphEdges(this.getGraph().getOutEdges((Object)vertex));
        explanation.setWeightStatuses(statuses);
        explanation.setFunction(threshold);
        HashMap<GraphEdge, GraphVertex> graphEdgeToGraphVertex = new HashMap<GraphEdge, GraphVertex>();
        for (Edge eachEdge : businessService.getEdges()) {
            GraphVertex vertexForEdge = this.getGraph().getVertexByEdgeId(eachEdge.getId());
            GraphEdge graphEdge = this.getGraph().getGraphEdgeByEdgeId(eachEdge.getId());
            if (vertexForEdge == null || graphEdge == null) continue;
            graphEdgeToGraphVertex.put(graphEdge, vertexForEdge);
        }
        explanation.setGraphEdgeToGraphVertexMapping(graphEdgeToGraphVertex);
        return explanation;
    }

    private List<GraphVertex> calculateImpact(GraphVertex vertex) {
        return GraphAlgorithms.calculateImpact((BusinessServiceGraph)this.m_g, (GraphVertex)vertex);
    }
}

