/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceChildEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceDao;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeDao;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;
import org.opennms.netmgt.bsm.persistence.api.IPServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.SingleReductionKeyEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.MapFunctionDao;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ReductionFunctionDao;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteria;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.internal.BusinessServiceImpl;
import org.opennms.netmgt.bsm.service.internal.IpServiceImpl;
import org.opennms.netmgt.bsm.service.internal.MapFunctionMapper;
import org.opennms.netmgt.bsm.service.internal.NodeImpl;
import org.opennms.netmgt.bsm.service.internal.ReduceFunctionMapper;
import org.opennms.netmgt.bsm.service.internal.edge.AbstractEdge;
import org.opennms.netmgt.bsm.service.internal.edge.ChildEdgeImpl;
import org.opennms.netmgt.bsm.service.internal.edge.IpServiceEdgeImpl;
import org.opennms.netmgt.bsm.service.internal.edge.ReductionKeyEdgeImpl;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Node;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.internal.BusinessServiceGraphImpl;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public class BusinessServiceManagerImpl
implements BusinessServiceManager {
    @Autowired
    private BusinessServiceDao businessServiceDao;
    @Autowired
    private BusinessServiceEdgeDao edgeDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private MapFunctionDao mapFunctionDao;
    @Autowired
    private ReductionFunctionDao reductionFunctionDao;
    @Autowired
    private BusinessServiceStateMachine businessServiceStateMachine;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private EventForwarder eventForwarder;

    public List<BusinessService> getAllBusinessServices() {
        return this.getDao().findAll().stream().map(s -> new BusinessServiceImpl(this, (BusinessServiceEntity)s)).collect(Collectors.toList());
    }

    public List<BusinessService> search(BusinessServiceSearchCriteria businessServiceSearchCriteria) {
        Objects.requireNonNull(businessServiceSearchCriteria);
        return businessServiceSearchCriteria.apply((BusinessServiceManager)this, this.getAllBusinessServices());
    }

    public List<BusinessService> findMatching(Criteria criteria) {
        criteria = this.transform(criteria);
        List all = this.getDao().findMatching(criteria);
        if (all == null) {
            return null;
        }
        return all.stream().map(e -> new BusinessServiceImpl(this, (BusinessServiceEntity)e)).collect(Collectors.toList());
    }

    public int countMatching(Criteria criteria) {
        criteria = this.transform(criteria);
        return this.getDao().countMatching(criteria);
    }

    public BusinessService createBusinessService() {
        return new BusinessServiceImpl(this, new BusinessServiceEntity());
    }

    private <T extends Edge> T createEdge(Class<T> type, BusinessService source, MapFunction mapFunction, int weight) {
        AbstractEdge edge = null;
        if (type == IpServiceEdge.class) {
            edge = new IpServiceEdgeImpl((BusinessServiceManager)this, new IPServiceEdgeEntity());
        }
        if (type == ChildEdge.class) {
            edge = new ChildEdgeImpl((BusinessServiceManager)this, new BusinessServiceChildEdgeEntity());
        }
        if (type == ReductionKeyEdge.class) {
            edge = new ReductionKeyEdgeImpl((BusinessServiceManager)this, new SingleReductionKeyEdgeEntity());
        }
        if (edge != null) {
            edge.setSource(source);
            edge.setMapFunction(mapFunction);
            edge.setWeight(weight);
            return (T)edge;
        }
        throw new IllegalArgumentException("Could not create edge for type " + type);
    }

    public Edge getEdgeById(Long edgeId) {
        BusinessServiceEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edgeId);
        return (Edge)edgeEntity.accept((EdgeEntityVisitor)new EdgeEntityVisitor<Edge>(){

            public Edge visit(BusinessServiceChildEdgeEntity edgeEntity) {
                return new ChildEdgeImpl((BusinessServiceManager)BusinessServiceManagerImpl.this, edgeEntity);
            }

            public Edge visit(SingleReductionKeyEdgeEntity edge) {
                return new ReductionKeyEdgeImpl((BusinessServiceManager)BusinessServiceManagerImpl.this, edge);
            }

            public Edge visit(IPServiceEdgeEntity edge) {
                return new IpServiceEdgeImpl((BusinessServiceManager)BusinessServiceManagerImpl.this, edge);
            }
        });
    }

    public boolean deleteEdge(BusinessService source, Edge edge) {
        BusinessServiceEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edge);
        BusinessServiceEntity businessServiceEntity = this.getBusinessServiceEntity(source);
        if (!businessServiceEntity.getEdges().contains(edgeEntity)) {
            return false;
        }
        businessServiceEntity.removeEdge(edgeEntity);
        return true;
    }

    public void saveBusinessService(BusinessService service) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(service);
        this.getDao().saveOrUpdate((Object)entity);
    }

    public Set<BusinessService> getParentServices(Long id) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(id);
        return this.businessServiceDao.findParents(entity).stream().map(bs -> new BusinessServiceImpl(this, (BusinessServiceEntity)bs)).collect(Collectors.toSet());
    }

    public BusinessService getBusinessServiceById(Long id) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(id);
        return new BusinessServiceImpl(this, entity);
    }

    public void deleteBusinessService(BusinessService businessService) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(businessService);
        for (BusinessServiceEntity parent : this.getDao().findParents(entity)) {
            List<BusinessServiceChildEdgeEntity> collect = parent.getChildEdges().stream().filter(e -> entity.equals((Object)e.getChild())).collect(Collectors.toList());
            collect.forEach(x -> {
                parent.removeEdge((BusinessServiceEdgeEntity)x);
                this.edgeDao.delete(x);
            });
        }
        this.getDao().delete((Object)entity);
    }

    public void setReductionKeyEdges(BusinessService businessService, Set<ReductionKeyEdge> reductionKeyEdges) {
        BusinessServiceEntity parentEntity = this.getBusinessServiceEntity(businessService);
        for (SingleReductionKeyEdgeEntity e2 : parentEntity.getReductionKeyEdges()) {
            parentEntity.removeEdge((BusinessServiceEdgeEntity)e2);
        }
        reductionKeyEdges.forEach(e -> parentEntity.addEdge(((ReductionKeyEdgeImpl)e).getEntity()));
    }

    public boolean addReductionKeyEdge(BusinessService businessService, String reductionKey, MapFunction mapFunction, int weight) {
        return this.addReductionKeyEdge(businessService, reductionKey, mapFunction, weight, null);
    }

    public boolean addReductionKeyEdge(BusinessService businessService, String reductionKey, MapFunction mapFunction, int weight, String friendlyName) {
        BusinessServiceEntity parentEntity = this.getBusinessServiceEntity(businessService);
        ReductionKeyEdgeImpl edge = (ReductionKeyEdgeImpl)this.createEdge(ReductionKeyEdge.class, businessService, mapFunction, weight);
        edge.setReductionKey(reductionKey);
        edge.setFriendlyName(friendlyName);
        SingleReductionKeyEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edge);
        long count = parentEntity.getReductionKeyEdges().stream().filter(e -> e.equalsDefinition((BusinessServiceEdgeEntity)edgeEntity)).count();
        if (count > 0L) {
            return false;
        }
        parentEntity.addEdge(edge.getEntity());
        return true;
    }

    public void setIpServiceEdges(BusinessService businessService, Set<IpServiceEdge> ipServiceEdges) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(businessService);
        for (IPServiceEdgeEntity e2 : entity.getIpServiceEdges()) {
            entity.removeEdge((BusinessServiceEdgeEntity)e2);
        }
        ipServiceEdges.forEach(e -> entity.addEdge(((IpServiceEdgeImpl)e).getEntity()));
    }

    public boolean addIpServiceEdge(BusinessService businessService, IpService ipService, MapFunction mapFunction, int weight) {
        return this.addIpServiceEdge(businessService, ipService, mapFunction, weight, null);
    }

    public boolean addIpServiceEdge(BusinessService businessService, IpService ipService, MapFunction mapFunction, int weight, String friendlyName) {
        BusinessServiceEntity parentEntity = this.getBusinessServiceEntity(businessService);
        IpServiceEdge edge = this.createEdge(IpServiceEdge.class, businessService, mapFunction, weight);
        edge.setIpService(ipService);
        edge.setFriendlyName(friendlyName);
        IPServiceEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edge);
        long count = parentEntity.getIpServiceEdges().stream().filter(e -> e.equalsDefinition((BusinessServiceEdgeEntity)edgeEntity)).count();
        if (count > 0L) {
            return false;
        }
        parentEntity.addEdge(((IpServiceEdgeImpl)edge).getEntity());
        return true;
    }

    public void setChildEdges(BusinessService parentService, Set<ChildEdge> childEdges) {
        BusinessServiceEntity parentEntity = this.getBusinessServiceEntity(parentService);
        for (BusinessServiceChildEdgeEntity e2 : parentEntity.getChildEdges()) {
            parentEntity.removeEdge((BusinessServiceEdgeEntity)e2);
        }
        childEdges.forEach(e -> parentEntity.addEdge(((ChildEdgeImpl)e).getEntity()));
    }

    public boolean addChildEdge(BusinessService parentService, BusinessService childService, MapFunction mapFunction, int weight) {
        BusinessServiceEntity parentEntity = this.getBusinessServiceEntity(parentService);
        BusinessServiceEntity childEntity = this.getBusinessServiceEntity(childService);
        ChildEdge childEdge = this.createEdge(ChildEdge.class, parentService, mapFunction, weight);
        childEdge.setChild(childService);
        if (this.checkDescendantForLoop(parentEntity, childEntity)) {
            throw new IllegalArgumentException("Service will form a loop");
        }
        BusinessServiceChildEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(childEdge);
        long count = parentEntity.getChildEdges().stream().filter(e -> e.equalsDefinition((BusinessServiceEdgeEntity)edgeEntity)).count();
        if (count > 0L) {
            return false;
        }
        parentEntity.addEdge(((ChildEdgeImpl)childEdge).getEntity());
        return true;
    }

    public void removeEdge(BusinessService businessService, Edge edge) {
        BusinessServiceEntity businessServiceEntity = this.getBusinessServiceEntity(businessService);
        BusinessServiceEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edge);
        businessServiceEntity.removeEdge(edgeEntity);
    }

    private boolean checkDescendantForLoop(BusinessServiceEntity parent, BusinessServiceEntity descendant) {
        if (parent.equals((Object)descendant)) {
            return true;
        }
        Iterator iterator = descendant.getChildEdges().iterator();
        if (iterator.hasNext()) {
            BusinessServiceChildEdgeEntity eachChildEdge = (BusinessServiceChildEdgeEntity)iterator.next();
            return this.checkDescendantForLoop(parent, eachChildEdge.getChild());
        }
        return false;
    }

    public Set<BusinessService> getFeasibleChildServices(BusinessService service) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(service);
        return this.getDao().findAll().stream().filter(s -> !this.checkDescendantForLoop(entity, (BusinessServiceEntity)s)).map(s -> new BusinessServiceImpl(this, (BusinessServiceEntity)s)).collect(Collectors.toSet());
    }

    public Status getOperationalStatus(BusinessService service) {
        Status status = this.businessServiceStateMachine.getOperationalStatus(service);
        return status != null ? status : Status.INDETERMINATE;
    }

    public Status getOperationalStatus(IpService ipService) {
        Status status = this.businessServiceStateMachine.getOperationalStatus(ipService);
        return status != null ? status : Status.INDETERMINATE;
    }

    public Status getOperationalStatus(String reductionKey) {
        Status status = this.businessServiceStateMachine.getOperationalStatus(reductionKey);
        return status != null ? status : Status.INDETERMINATE;
    }

    public Status getOperationalStatus(Edge edge) {
        Status status = this.businessServiceStateMachine.getOperationalStatus(edge);
        return status != null ? status : Status.INDETERMINATE;
    }

    public List<IpService> getAllIpServices() {
        return this.monitoredServiceDao.findAll().stream().map(s -> new IpServiceImpl(this, (OnmsMonitoredService)s)).collect(Collectors.toList());
    }

    public IpService getIpServiceById(Integer id) {
        OnmsMonitoredService entity = this.getMonitoredServiceEntity(id);
        return new IpServiceImpl(this, entity);
    }

    public void triggerDaemonReload() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "BSM Master Page");
        eventBuilder.addParam("daemonName", "bsmd");
        this.eventForwarder.sendNow(eventBuilder.getEvent());
    }

    public Node getNodeById(Integer nodeId) {
        return new NodeImpl(this.getNodeEntity(nodeId));
    }

    public BusinessServiceGraph getGraph(List<BusinessService> businessServices) {
        return new BusinessServiceGraphImpl(businessServices);
    }

    public BusinessServiceGraph getGraph() {
        return this.businessServiceStateMachine.getGraph();
    }

    public BusinessServiceStateMachine getStateMachine() {
        return this.businessServiceStateMachine;
    }

    public void setMapFunction(Edge edge, MapFunction mapFunction) {
        BusinessServiceEdgeEntity edgeEntity = this.getBusinessServiceEdgeEntity(edge);
        AbstractMapFunctionEntity prevMapFunctionEntity = edgeEntity.getMapFunction();
        if (prevMapFunctionEntity != null && prevMapFunctionEntity.getId() != null) {
            this.mapFunctionDao.delete((Object)prevMapFunctionEntity);
        }
        AbstractMapFunctionEntity mapFunctionEntity = new MapFunctionMapper().toPersistenceFunction(mapFunction);
        edgeEntity.setMapFunction(mapFunctionEntity);
    }

    public void setReduceFunction(BusinessService businessService, ReductionFunction reductionFunction) {
        BusinessServiceEntity entity = this.getBusinessServiceEntity(businessService);
        AbstractReductionFunctionEntity prevReduceFunctionEntity = entity.getReductionFunction();
        if (prevReduceFunctionEntity != null && prevReduceFunctionEntity.getId() != null) {
            this.reductionFunctionDao.delete((Object)prevReduceFunctionEntity);
        }
        AbstractReductionFunctionEntity reduceFunctionEntity = new ReduceFunctionMapper().toPersistenceFunction(reductionFunction);
        entity.setReductionFunction(reduceFunctionEntity);
    }

    protected BusinessServiceDao getDao() {
        return this.businessServiceDao;
    }

    private OnmsNode getNodeEntity(Integer nodeId) {
        Objects.requireNonNull(nodeId);
        OnmsNode entity = (OnmsNode)this.nodeDao.get((Serializable)nodeId);
        if (entity == null) {
            throw new NoSuchElementException("OnmsNode with id " + nodeId);
        }
        return entity;
    }

    private BusinessServiceEdgeEntity getBusinessServiceEdgeEntity(Edge edge) {
        return ((AbstractEdge)edge).getEntity();
    }

    private BusinessServiceEdgeEntity getBusinessServiceEdgeEntity(Long edgeId) {
        Objects.requireNonNull(edgeId);
        BusinessServiceEdgeEntity edgeEntity = (BusinessServiceEdgeEntity)this.edgeDao.get((Serializable)edgeId);
        if (edgeEntity == null) {
            throw new NoSuchElementException("BusinessServiceEdgeEntity with id " + edgeId);
        }
        return edgeEntity;
    }

    private IPServiceEdgeEntity getBusinessServiceEdgeEntity(IpServiceEdge ipServiceEdge) {
        return (IPServiceEdgeEntity)((IpServiceEdgeImpl)ipServiceEdge).getEntity();
    }

    private BusinessServiceChildEdgeEntity getBusinessServiceEdgeEntity(ChildEdge childEdge) {
        return (BusinessServiceChildEdgeEntity)((ChildEdgeImpl)childEdge).getEntity();
    }

    private SingleReductionKeyEdgeEntity getBusinessServiceEdgeEntity(ReductionKeyEdge reductionKeyEdge) {
        return (SingleReductionKeyEdgeEntity)((ReductionKeyEdgeImpl)reductionKeyEdge).getEntity();
    }

    private BusinessServiceEntity getBusinessServiceEntity(BusinessService service) throws NoSuchElementException {
        return ((BusinessServiceImpl)service).getEntity();
    }

    private BusinessServiceEntity getBusinessServiceEntity(Long serviceId) throws NoSuchElementException {
        Objects.requireNonNull(serviceId);
        BusinessServiceEntity entity = (BusinessServiceEntity)this.getDao().get((Serializable)serviceId);
        if (entity == null) {
            throw new NoSuchElementException("BusinessServiceEntity with id " + serviceId);
        }
        return entity;
    }

    private OnmsMonitoredService getMonitoredServiceEntity(Integer serviceId) throws NoSuchElementException {
        Objects.requireNonNull(serviceId);
        OnmsMonitoredService monitoredService = (OnmsMonitoredService)this.monitoredServiceDao.get((Serializable)serviceId);
        if (monitoredService == null) {
            throw new NoSuchElementException("OnmsMonitoredService with id " + serviceId);
        }
        return monitoredService;
    }

    private Criteria transform(Criteria input) {
        Criteria criteria = input.clone();
        criteria.setClass(BusinessServiceEntity.class);
        return criteria;
    }
}

