/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.daemon;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateChangeHandler;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.internal.AlarmWrapperImpl;
import org.opennms.netmgt.bsm.service.internal.SeverityMapper;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@EventListener(name="Bsmd", logPrefix="bsmd")
public class Bsmd
implements SpringServiceDaemon,
BusinessServiceStateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Bsmd.class);
    protected static final long DEFAULT_POLL_INTERVAL = 30L;
    protected static final String POLL_INTERVAL_KEY = "org.opennms.features.bsm.pollInterval";
    public static final String NAME = "Bsmd";
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    @Qualifier(value="eventIpcManager")
    private EventIpcManager m_eventIpcManager;
    @Autowired
    private EventConfDao m_eventConfDao;
    @Autowired
    private TransactionTemplate m_template;
    @Autowired
    private BusinessServiceStateMachine m_stateMachine;
    @Autowired
    private BusinessServiceManager m_manager;
    private boolean m_verifyReductionKeys = true;
    final ScheduledExecutorService alarmPoller = Executors.newScheduledThreadPool(1);

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.m_stateMachine, "stateMachine cannot be null");
        LOG.info("Initializing bsmd...");
        this.m_stateMachine.addHandler((BusinessServiceStateChangeHandler)this, null);
    }

    public void start() throws Exception {
        Objects.requireNonNull(this.m_manager, "businessServiceDao cannot be null");
        Objects.requireNonNull(this.m_alarmDao, "alarmDao cannot be null");
        Objects.requireNonNull(this.m_eventIpcManager, "eventIpcManager cannot be null");
        Objects.requireNonNull(this.m_eventConfDao, "eventConfDao cannot be null");
        this.handleConfigurationChanged();
        this.startAlarmPolling();
    }

    private void startAlarmPolling() {
        long pollInterval = this.getPollInterval();
        this.alarmPoller.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Polling alarm table...");
                    Bsmd.this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            Bsmd.this.m_alarmDao.findAll().forEach(alarm -> Bsmd.this.handleAlarm(alarm));
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.error("Error while polling alarm table", (Throwable)ex);
                }
                finally {
                    LOG.debug("Polling alarm table DONE");
                }
            }
        }, pollInterval, pollInterval, TimeUnit.SECONDS);
    }

    protected long getPollInterval() {
        String pollIntervalProperty = System.getProperty(POLL_INTERVAL_KEY, Long.toString(30L));
        try {
            long pollInterval = Long.valueOf(pollIntervalProperty);
            if (pollInterval <= 0L) {
                LOG.warn("Defined pollInterval must be greater than 0, but was {}. Falling back to default: {}", (Object)pollInterval, (Object)30L);
                return 30L;
            }
            LOG.debug("Using poll interval {}", (Object)pollInterval);
            return pollInterval;
        }
        catch (Exception ex) {
            LOG.warn("The defined pollInterval {} could not be interpreted as long value. Falling back to default: {}", (Object)pollIntervalProperty, (Object)30L);
            return 30L;
        }
    }

    private void handleConfigurationChanged() {
        if (this.m_verifyReductionKeys) {
            this.verifyReductionKey("uei.opennms.org/nodes/nodeLostService", "%uei%:%dpname%:%nodeid%:%interface%:%service%");
            this.verifyReductionKey("uei.opennms.org/nodes/nodeDown", "%uei%:%dpname%:%nodeid%");
            this.verifyReductionKey("uei.opennms.org/nodes/interfaceDown", "%uei%:%dpname%:%nodeid%:%interface%");
        }
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List businessServices = Bsmd.this.m_manager.getAllBusinessServices();
                LOG.debug("Adding {} business services to the state machine.", (Object)businessServices.size());
                Bsmd.this.m_stateMachine.setBusinessServices(businessServices);
            }
        });
    }

    private void verifyReductionKey(String uei, String reductionKey) {
        List eventsForUei = this.m_eventConfDao.getEvents(uei);
        if (eventsForUei.size() != 1) {
            throw new IllegalStateException("Could not find a unique event definition for uei: " + uei);
        }
        Event event = (Event)eventsForUei.get(0);
        if (!reductionKey.equals(event.getAlarmData().getReductionKey())) {
            throw new IllegalStateException("Unsupported reduction key " + event.getAlarmData().getReductionKey());
        }
    }

    @EventHandler(ueis={"uei.opennms.org/alarms/alarmCreated", "uei.opennms.org/alarms/alarmEscalated", "uei.opennms.org/alarms/alarmCleared", "uei.opennms.org/alarms/alarmUncleared", "uei.opennms.org/alarms/alarmUpdatedWithReducedEvent"})
    public void handleAlarmLifecycleEvents(final org.opennms.netmgt.xml.event.Event e) {
        int alarmId;
        if (e == null) {
            return;
        }
        Parm alarmIdParm = e.getParm("alarmId");
        if (alarmIdParm == null || alarmIdParm.getValue() == null) {
            LOG.warn("The alarmId parameter has no value on event with uei: {}. Ignoring.", (Object)e.getUei());
            return;
        }
        try {
            alarmId = Integer.parseInt(alarmIdParm.getValue().getContent());
        }
        catch (NumberFormatException ee) {
            LOG.warn("Failed to retrieve the alarmId for event with uei: {}. Ignoring.", (Object)e.getUei(), (Object)ee);
            return;
        }
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Bsmd.this.m_alarmDao.flush();
                OnmsAlarm alarm = (OnmsAlarm)Bsmd.this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
                if (alarm == null) {
                    LOG.error("Could not find alarm with id: {} for event with uei: {}. Ignoring.", (Object)alarmId, (Object)e.getUei());
                    return;
                }
                Bsmd.this.handleAlarm(alarm);
            }
        });
    }

    private void handleAlarm(OnmsAlarm alarm) {
        AlarmWrapperImpl alarmWrapper = new AlarmWrapperImpl(alarm);
        LOG.debug("Handling alarm with id: {}, reduction key: {} and severity: {} and status: {}", new Object[]{alarm.getId(), alarm.getReductionKey(), alarm.getSeverity(), alarmWrapper.getStatus()});
        this.m_stateMachine.handleNewOrUpdatedAlarm((AlarmWrapper)alarmWrapper);
    }

    public void handleBusinessServiceStateChanged(BusinessService businessService, Status newStatus, Status prevStatus) {
        OnmsSeverity newSeverity = SeverityMapper.toSeverity(newStatus);
        OnmsSeverity prevSeverity = SeverityMapper.toSeverity(prevStatus);
        EventBuilder ebldr = new EventBuilder("uei.opennms.org/bsmd/serviceOperationalStatusChanged", NAME);
        ebldr.addParam("businessServiceId", businessService.getId().longValue());
        ebldr.addParam("businessServiceName", businessService.getName());
        ebldr.addParam("prevSeverityId", prevSeverity.getId());
        ebldr.addParam("prevSeverityLabel", prevSeverity.getLabel());
        ebldr.addParam("newSeverityId", newSeverity.getId());
        ebldr.addParam("newSeverityLabel", newSeverity.getLabel());
        this.m_eventIpcManager.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(org.opennms.netmgt.xml.event.Event e) {
        LOG.info("Received a reload configuration event: {}", (Object)e);
        Parm daemonNameParm = e.getParm("daemonName");
        if (daemonNameParm == null || daemonNameParm.getValue() == null) {
            LOG.warn("The {} parameter has no value. Ignoring.", (Object)"daemonName");
            return;
        }
        if (NAME.equalsIgnoreCase(daemonNameParm.getValue().getContent())) {
            LOG.info("Reloading bsmd.");
            EventBuilder ebldr = null;
            try {
                this.handleConfigurationChanged();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", NAME);
                ebldr.addParam("daemonName", NAME);
                LOG.info("Reload successful.");
            }
            catch (Throwable t) {
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", NAME);
                ebldr.addParam("reason", t.getLocalizedMessage().substring(0, 128));
                LOG.error("Reload failed.", t);
            }
            ebldr.addParam("daemonName", NAME);
            this.m_eventIpcManager.sendNow(ebldr.getEvent());
        }
    }

    public void destroy() throws Exception {
        LOG.info("Stopping bsmd...");
        this.alarmPoller.shutdown();
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.m_template;
    }

    public void setVerifyReductionKeys(boolean verify) {
        this.m_verifyReductionKeys = verify;
    }

    public boolean getVerifyReductionKeys() {
        return this.m_verifyReductionKeys;
    }

    public void setBusinessServiceStateMachine(BusinessServiceStateMachine stateMachine) {
        this.m_stateMachine = stateMachine;
    }

    public BusinessServiceStateMachine getBusinessServiceStateMachine() {
        return this.m_stateMachine;
    }
}

