/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.eventreceiver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import org.apache.camel.BeanInject;
import org.apache.camel.util.KeyValueHolder;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.core.test.camel.CamelBlueprintTest;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.mock.MockNodeDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;

@Ignore
public class AMQPEventReceiverBlueprintTest
extends CamelBlueprintTest {
    @BeanInject
    protected EventIpcManager eventIpcManager;

    protected String getBlueprintDescriptor() {
        return "OSGI-INF/blueprint/blueprint-event-receiver.xml";
    }

    protected String useOverridePropertiesWithConfigAdmin(Dictionary props) {
        props.put("source", "direct:source");
        return "org.opennms.features.amqp.eventreceiver";
    }

    protected void addServicesOnStartup(Map<String, KeyValueHolder<Object, Dictionary>> services) {
        MockEventIpcManager mockEventIpcManager = new MockEventIpcManager();
        services.put(EventIpcManager.class.getName(), (KeyValueHolder<Object, Dictionary>)this.asService(mockEventIpcManager, null));
        MockNodeDao mockNodeDao = new MockNodeDao();
        services.put(NodeDao.class.getName(), (KeyValueHolder<Object, Dictionary>)this.asService(mockNodeDao, null));
    }

    @Test
    public void canReceiveEvent() throws Exception {
        final ArrayList receivedEvents = Lists.newArrayList();
        this.eventIpcManager.addEventListener(new EventListener(){

            public String getName() {
                return "test";
            }

            public void onEvent(Event e) {
                receivedEvents.add(e);
            }
        });
        Event event = new Event();
        this.template.sendBody("direct:source", (Object)event);
        this.assertMockEndpointsSatisfied();
        for (int i = 0; i < 60 && receivedEvents.size() == 0; i += 5) {
            Thread.sleep(5L);
        }
        AMQPEventReceiverBlueprintTest.assertEquals((long)1L, (long)receivedEvents.size());
    }
}

