/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.shell;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.features.activemq.broker.api.ManagedBroker;
import org.opennms.features.activemq.broker.api.ManagedDestination;

@Service
public class QueueNameCompleter
implements Completer {
    @Reference(optional=true)
    private ManagedBroker broker;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        delegate.getStrings().addAll(this.getQueueNames());
        return delegate.complete(session, commandLine, candidates);
    }

    private Set<String> getQueueNames() {
        if (this.broker == null) {
            return Collections.emptySet();
        }
        return this.broker.getDestinations().stream().filter(ManagedDestination::isQueue).map(ManagedDestination::getName).collect(Collectors.toSet());
    }
}

