/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.activemq.broker.api.ManagedBroker;
import org.opennms.features.activemq.broker.api.ManagedDestination;
import org.opennms.features.activemq.shell.QueueNameCompleter;

@Command(scope="opennms-activemq", name="purge-queue", description="Purge the content of an ActiveMQ queue.")
@Service
public class PurgeQueue
implements Action {
    @Reference(optional=true)
    private ManagedBroker broker;
    @Argument(name="queue name", required=true)
    @Completion(value=QueueNameCompleter.class)
    private String queueName;

    public Object execute() throws Exception {
        if (this.broker == null) {
            System.out.println("(No broker available.)");
            return null;
        }
        ManagedDestination queue = this.broker.getDestinations().stream().filter(ManagedDestination::isQueue).filter(q -> this.queueName.trim().equalsIgnoreCase(q.getName())).findFirst().orElse(null);
        if (queue == null) {
            System.out.printf("No queue named '%s' found.\n", this.queueName);
        } else {
            System.out.println("Purging: " + queue.getName());
            queue.purge();
        }
        return null;
    }
}

