/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.eventforwarder;

import java.util.ArrayList;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class ForwardingEventListener
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingEventListener.class);
    private volatile EventForwarder eventForwarder;
    private volatile EventIpcManager eventIpcManager;
    private volatile NodeDao nodeDao;
    private volatile TransactionTemplate transactionTemplate;

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public EventIpcManager getEventIpcManager() {
        return this.eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.eventIpcManager = eventIpcManager;
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void init() {
        Assert.notNull((Object)this.eventIpcManager, (String)"eventIpcManager must not be null");
        Assert.notNull((Object)this.eventForwarder, (String)"eventForwarder must not be null");
        this.installMessageSelectors();
    }

    private void installMessageSelectors() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeAdded");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        ueiList.add("uei.opennms.org/nodes/nodeDown");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/nodeInfoChanged");
        ueiList.add("uei.opennms.org/nodes/nodeLabelChanged");
        ueiList.add("uei.opennms.org/nodes/nodeLabelSourceChanged");
        ueiList.add("uei.opennms.org/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/nodes/nodeRegainedService");
        ueiList.add("uei.opennms.org/nodes/nodeUp");
        ueiList.add("uei.opennms.org/nodes/nodeUpdated");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDown");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/interfaceUp");
        ueiList.add("uei.opennms.org/internal/ncs/componentAdded");
        ueiList.add("uei.opennms.org/internal/ncs/componentDeleted");
        ueiList.add("uei.opennms.org/internal/ncs/componentUpdated");
        ueiList.add("uei.opennms.org/threshold/highThresholdExceeded");
        ueiList.add("uei.opennms.org/threshold/highThresholdRearmed");
        ueiList.add("uei.opennms.org/threshold/lowThresholdExceeded");
        ueiList.add("uei.opennms.org/threshold/lowThresholdRearmed");
        ueiList.add("uei.opennms.org/nodes/pathOutage");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/nodes/serviceResponsive");
        ueiList.add("uei.opennms.org/internal/unknownServiceStatus");
        ueiList.add("uei.opennms.org/nodes/serviceUnmanaged");
        ueiList.add("uei.opennms.org/nodes/serviceUnresponsive");
        ueiList.add("uei.opennms.org/nodes/snmp/interfaceAdminDown");
        ueiList.add("uei.opennms.org/nodes/snmp/interfaceAdminUp");
        ueiList.add("uei.opennms.org/nodes/snmp/interfaceOperDown");
        ueiList.add("uei.opennms.org/nodes/snmp/interfaceOperUp");
        ueiList.add("uei.opennms.org/internal/topology/linkDown");
        ueiList.add("uei.opennms.org/internal/topology/linkUp");
        ueiList.add("uei.opennms.org/internal/capsd/updateServer");
        ueiList.add("uei.opennms.org/internal/capsd/updateService");
        ueiList.add("uei.opennms.org/remote/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/remote/nodes/nodeRegainedService");
        ueiList.add("uei.opennms.org/remote/locationMonitorRegistered");
        ueiList.add("uei.opennms.org/remote/locationMonitorStarted");
        ueiList.add("uei.opennms.org/remote/locationMonitorStopped");
        ueiList.add("uei.opennms.org/remote/locationMonitorPaused");
        ueiList.add("uei.opennms.org/remote/locationMonitorDisconnected");
        ueiList.add("uei.opennms.org/remote/locationMonitorReconnected");
        ueiList.add("uei.opennms.org/remote/configurationChangeDetected");
        ueiList.add("uei.opennms.org/remote/locationMonitorConnectionAddressChanged");
        this.getEventIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void onEvent(Event event) {
        LOG.debug("Forwarding Event %s", (Object)event.getUei());
        this.eventForwarder.sendNow(event);
    }

    public String getName() {
        return "ActiveMQEventForwarder";
    }
}

