/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools.config;

import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.drools.config.RuleSet;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

@XmlRootElement(name="engine-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EngineConfiguration
implements Serializable {
    private static final long serialVersionUID = 2358050053659695907L;
    private static final Logger LOG = LoggerFactory.getLogger(EngineConfiguration.class);
    @XmlElement(name="rule-set")
    private List<RuleSet> _ruleSetList = new ArrayList<RuleSet>();

    public void addRuleSet(RuleSet vRuleSet) throws IndexOutOfBoundsException {
        this._ruleSetList.add(vRuleSet);
    }

    public void addRuleSet(int index, RuleSet vRuleSet) throws IndexOutOfBoundsException {
        this._ruleSetList.add(index, vRuleSet);
    }

    public Enumeration<RuleSet> enumerateRuleSet() {
        return Collections.enumeration(this._ruleSetList);
    }

    public RuleSet getRuleSet(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleSetList.size()) {
            throw new IndexOutOfBoundsException("getRuleSet: Index value '" + index + "' not in range [0.." + (this._ruleSetList.size() - 1) + "]");
        }
        return this._ruleSetList.get(index);
    }

    public RuleSet[] getRuleSet() {
        RuleSet[] array = new RuleSet[]{};
        return this._ruleSetList.toArray(array);
    }

    public List<RuleSet> getRuleSetCollection() {
        return this._ruleSetList;
    }

    public int getRuleSetCount() {
        return this._ruleSetList.size();
    }

    public Iterator<RuleSet> iterateRuleSet() {
        return this._ruleSetList.iterator();
    }

    public void removeAllRuleSet() {
        this._ruleSetList.clear();
    }

    public boolean removeRuleSet(RuleSet vRuleSet) {
        return this._ruleSetList.remove(vRuleSet);
    }

    public RuleSet removeRuleSetAt(int index) {
        return this._ruleSetList.remove(index);
    }

    public void setRuleSet(int index, RuleSet vRuleSet) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleSetList.size()) {
            throw new IndexOutOfBoundsException("setRuleSet: Index value '" + index + "' not in range [0.." + (this._ruleSetList.size() - 1) + "]");
        }
        this._ruleSetList.set(index, vRuleSet);
    }

    public void setRuleSet(RuleSet[] vRuleSetArray) {
        this.setRuleSet(Arrays.asList(vRuleSetArray));
    }

    public void setRuleSet(List<RuleSet> vRuleSetList) {
        this._ruleSetList.clear();
        this._ruleSetList.addAll(vRuleSetList);
    }

    public void setRuleSetCollection(List<RuleSet> ruleSetList) {
        this._ruleSetList = ruleSetList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._ruleSetList == null ? 0 : this._ruleSetList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EngineConfiguration other = (EngineConfiguration)obj;
        return !(this._ruleSetList == null ? other._ruleSetList != null : !this._ruleSetList.equals(other._ruleSetList));
    }

    public CorrelationEngine[] constructEngines(Resource basePath, ApplicationContext appContext, EventIpcManager eventIpcManager, MetricRegistry metricRegistry) {
        LOG.info("Creating drools engines for configuration {}.", (Object)basePath);
        ArrayList<CorrelationEngine> engineList = new ArrayList<CorrelationEngine>();
        for (RuleSet ruleSet : this.getRuleSet()) {
            LOG.debug("Constucting engine for ruleset {} in configuration {}.", (Object)ruleSet.getName(), (Object)basePath);
            engineList.add(ruleSet.constructEngine(basePath, appContext, eventIpcManager, metricRegistry));
        }
        return engineList.toArray(new CorrelationEngine[0]);
    }

    public CorrelationEngine constructEngine(Resource basePath, ApplicationContext appContext, EventIpcManager eventIpcManager, MetricRegistry metricRegistry, String engineName) {
        for (RuleSet ruleSet : this.getRuleSet()) {
            if (!ruleSet.getName().equals(engineName)) continue;
            LOG.debug("Constucting engine for ruleset {} in configuration {}.", (Object)ruleSet.getName(), (Object)basePath);
            return ruleSet.constructEngine(basePath, appContext, eventIpcManager, metricRegistry);
        }
        return null;
    }
}

