/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools.config;

import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.drools.ConfigFileApplicationContext;
import org.opennms.netmgt.correlation.drools.DroolsCorrelationEngine;
import org.opennms.netmgt.correlation.drools.config.Global;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@XmlRootElement(name="rule-set")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RuleSet
implements Serializable {
    private static final long serialVersionUID = -3322760518752114255L;
    @XmlAttribute(name="name")
    private String _name;
    @XmlAttribute(name="assert-behaviour")
    private String _assertBehaviour;
    @XmlAttribute(name="event-processing-mode")
    private String _eventProcessingMode;
    @XmlAttribute(name="persist-state")
    private Boolean _persistState;
    @XmlElement(name="rule-file")
    private List<String> _ruleFileList = new ArrayList<String>();
    @XmlElement(name="event")
    private List<String> _eventList = new ArrayList<String>();
    @XmlElement(name="app-context")
    private String _appContext;
    @XmlElement(name="global")
    private List<Global> _globalList = new ArrayList<Global>();

    public String getAssertBehaviour() {
        return this._assertBehaviour == null ? "identity" : this._assertBehaviour;
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this._assertBehaviour = assertBehaviour;
    }

    public String getEventProcessingMode() {
        return this._eventProcessingMode == null ? "cloud" : this._eventProcessingMode;
    }

    public void setEventProcessingMode(String eventProcessingMode) {
        this._eventProcessingMode = eventProcessingMode;
    }

    public Boolean getPersistState() {
        return this._persistState == null ? false : this._persistState;
    }

    public void setPersistState(Boolean persistState) {
        this._persistState = persistState;
    }

    public void addEvent(String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(vEvent);
    }

    public void addEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(index, vEvent);
    }

    public void addGlobal(Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(vGlobal);
    }

    public void addGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(index, vGlobal);
    }

    public void addRuleFile(String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(vRuleFile);
    }

    public void addRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(index, vRuleFile);
    }

    public Enumeration<String> enumerateEvent() {
        return Collections.enumeration(this._eventList);
    }

    public Enumeration<Global> enumerateGlobal() {
        return Collections.enumeration(this._globalList);
    }

    public Enumeration<String> enumerateRuleFile() {
        return Collections.enumeration(this._ruleFileList);
    }

    public String getAppContext() {
        return this._appContext;
    }

    public String getEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._eventList.size()) {
            throw new IndexOutOfBoundsException("getEvent: Index value '" + index + "' not in range [0.." + (this._eventList.size() - 1) + "]");
        }
        return this._eventList.get(index);
    }

    public String[] getEvent() {
        String[] array = new String[]{};
        return this._eventList.toArray(array);
    }

    public List<String> getEventCollection() {
        return this._eventList;
    }

    public int getEventCount() {
        return this._eventList.size();
    }

    public Global getGlobal(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._globalList.size()) {
            throw new IndexOutOfBoundsException("getGlobal: Index value '" + index + "' not in range [0.." + (this._globalList.size() - 1) + "]");
        }
        return this._globalList.get(index);
    }

    public Global[] getGlobal() {
        Global[] array = new Global[]{};
        return this._globalList.toArray(array);
    }

    public List<Global> getGlobalCollection() {
        return this._globalList;
    }

    public int getGlobalCount() {
        return this._globalList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getRuleFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException("getRuleFile: Index value '" + index + "' not in range [0.." + (this._ruleFileList.size() - 1) + "]");
        }
        return this._ruleFileList.get(index);
    }

    public String[] getRuleFile() {
        String[] array = new String[]{};
        return this._ruleFileList.toArray(array);
    }

    public List<String> getRuleFileCollection() {
        return this._ruleFileList;
    }

    public int getRuleFileCount() {
        return this._ruleFileList.size();
    }

    public Iterator<String> iterateEvent() {
        return this._eventList.iterator();
    }

    public Iterator<Global> iterateGlobal() {
        return this._globalList.iterator();
    }

    public Iterator<String> iterateRuleFile() {
        return this._ruleFileList.iterator();
    }

    public void removeAllEvent() {
        this._eventList.clear();
    }

    public void removeAllGlobal() {
        this._globalList.clear();
    }

    public void removeAllRuleFile() {
        this._ruleFileList.clear();
    }

    public boolean removeEvent(String vEvent) {
        boolean removed = this._eventList.remove(vEvent);
        return removed;
    }

    public String removeEventAt(int index) {
        String obj = this._eventList.remove(index);
        return obj;
    }

    public boolean removeGlobal(Global vGlobal) {
        boolean removed = this._globalList.remove(vGlobal);
        return removed;
    }

    public Global removeGlobalAt(int index) {
        Global obj = this._globalList.remove(index);
        return obj;
    }

    public boolean removeRuleFile(String vRuleFile) {
        boolean removed = this._ruleFileList.remove(vRuleFile);
        return removed;
    }

    public String removeRuleFileAt(int index) {
        String obj = this._ruleFileList.remove(index);
        return obj;
    }

    public void setAppContext(String appContext) {
        this._appContext = appContext;
    }

    public void setEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._eventList.size()) {
            throw new IndexOutOfBoundsException("setEvent: Index value '" + index + "' not in range [0.." + (this._eventList.size() - 1) + "]");
        }
        this._eventList.set(index, vEvent);
    }

    public void setEvent(String[] vEventArray) {
        this._eventList.clear();
        this._eventList.addAll(Arrays.asList(vEventArray));
    }

    public void setEvent(List<String> vEventList) {
        this._eventList.clear();
        this._eventList.addAll(vEventList);
    }

    public void setEventCollection(List<String> eventList) {
        this._eventList = eventList;
    }

    public void setGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._globalList.size()) {
            throw new IndexOutOfBoundsException("setGlobal: Index value '" + index + "' not in range [0.." + (this._globalList.size() - 1) + "]");
        }
        this._globalList.set(index, vGlobal);
    }

    public void setGlobal(Global[] vGlobalArray) {
        this._globalList.clear();
        this._globalList.addAll(Arrays.asList(vGlobalArray));
    }

    public void setGlobal(List<Global> vGlobalList) {
        this._globalList.clear();
        this._globalList.addAll(vGlobalList);
    }

    public void setGlobalCollection(List<Global> globalList) {
        this._globalList = globalList;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException("setRuleFile: Index value '" + index + "' not in range [0.." + (this._ruleFileList.size() - 1) + "]");
        }
        this._ruleFileList.set(index, vRuleFile);
    }

    public void setRuleFile(String[] vRuleFileArray) {
        this._ruleFileList.clear();
        this._ruleFileList.addAll(Arrays.asList(vRuleFileArray));
    }

    public void setRuleFile(List<String> vRuleFileList) {
        this._ruleFileList.clear();
        this._ruleFileList.addAll(vRuleFileList);
    }

    public void setRuleFileCollection(List<String> ruleFileList) {
        this._ruleFileList = ruleFileList;
    }

    public int hashCode() {
        return Objects.hash(this._name, this._assertBehaviour, this._eventProcessingMode, this._persistState, this._ruleFileList, this._eventList, this._appContext, this._globalList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleSet other = (RuleSet)obj;
        return Objects.equals(this._name, other._name) && Objects.equals(this._assertBehaviour, other._assertBehaviour) && Objects.equals(this._eventProcessingMode, other._eventProcessingMode) && Objects.equals(this._persistState, other._persistState) && Objects.equals(this._ruleFileList, other._ruleFileList) && Objects.equals(this._eventList, other._eventList) && Objects.equals(this._appContext, other._appContext) && Objects.equals(this._globalList, other._globalList);
    }

    public CorrelationEngine constructEngine(Resource basePath, ApplicationContext appContext, EventIpcManager eventIpcManager, MetricRegistry metricRegistry) {
        ConfigFileApplicationContext configContext = new ConfigFileApplicationContext(basePath, this.getConfigLocation(), appContext);
        DroolsCorrelationEngine engine = new DroolsCorrelationEngine(this.getName(), metricRegistry, basePath, (ApplicationContext)configContext);
        engine.setEventIpcManager(eventIpcManager);
        this.updateEngine(engine);
        try {
            engine.initialize();
            return engine;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to initialize Drools engine " + this.getName(), e);
        }
    }

    public void updateEngine(DroolsCorrelationEngine engine) {
        engine.setAssertBehaviour(this.getAssertBehaviour());
        engine.setEventProcessingMode(this.getEventProcessingMode());
        engine.setPersistState(this.getPersistState());
        engine.setScheduler(new ScheduledThreadPoolExecutor(1));
        engine.setInterestingEvents(this.getInterestingEvents());
        engine.setRulesResources(this.getRuleResources((ResourceLoader)engine.getConfigContext()));
        engine.setGlobals(this.getGlobals(engine.getConfigContext()));
    }

    public Map<String, Object> getGlobals(ApplicationContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        for (Global global : this.getGlobal()) {
            globals.put(global.getName(), global.constructValue(context));
        }
        return globals;
    }

    public List<String> getInterestingEvents() {
        return Arrays.asList(this.getEvent());
    }

    public Resource getResource(ResourceLoader resourceLoader, String resourcePath) {
        return resourceLoader.getResource(PropertiesUtils.substitute((String)resourcePath, (Properties[])new Properties[]{System.getProperties()}));
    }

    public List<Resource> getRuleResources(ResourceLoader resourceLoader) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String resourcePath : this.getRuleFile()) {
            resources.add(this.getResource(resourceLoader, resourcePath));
        }
        return resources;
    }

    public String getConfigLocation() {
        return PropertiesUtils.substitute((String)this.getAppContext(), (Properties[])new Properties[]{System.getProperties()});
    }

    public String toString() {
        return "RuleSet[" + this.getName() + "]";
    }
}

