/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.correlation.drools.config.EngineConfiguration;
import org.opennms.netmgt.correlation.drools.config.RuleSet;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.Assert;

public class DroolsCorrelationEngineBuilder
extends PropertyEditorRegistrySupport
implements InitializingBean,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsCorrelationEngineBuilder.class);
    public static final String PLUGIN_CONFIG_FILE_NAME = "drools-engine.xml";
    @Resource(name="droolsCorrelationEngineBuilderConfigurationDirectory")
    private File m_configDirectory;
    @Resource(name="droolsCorrelationEngineBuilderConfigurationResource")
    private org.springframework.core.io.Resource m_configResource;
    @Autowired
    @Qualifier(value="eventIpcManager")
    private EventIpcManager m_eventIpcManager;
    @Autowired
    @Qualifier(value="correlator")
    private CorrelationEngineRegistrar m_correlator;
    @Autowired
    @Qualifier(value="metricRegistry")
    private MetricRegistry m_metricRegistry;
    @Autowired
    private ApplicationContext m_appContext;
    private PluginConfiguration[] m_pluginConfigurations;

    public DroolsCorrelationEngineBuilder() {
        this.registerDefaultEditors();
    }

    public void assertSet(Object obj, String name) {
        Assert.state((obj != null ? 1 : 0) != 0, (String)(name + " required for DroolsEngineFactoryBean"));
    }

    public void afterPropertiesSet() throws Exception {
        this.assertSet(this.m_configDirectory, "configurationDirectory");
        this.assertSet(this.m_eventIpcManager, "eventIpcManager");
        this.assertSet(this.m_correlator, "correlator");
        this.assertSet(this.m_metricRegistry, "metricRegistry");
        this.assertSet(this.m_appContext, "applicationContext");
        Assert.state((!this.m_configDirectory.exists() || this.m_configDirectory.isDirectory() ? 1 : 0) != 0, (String)(this.m_configDirectory + " must be a directory!"));
        this.m_eventIpcManager.addEventListener((EventListener)this, "uei.opennms.org/internal/reloadDaemonConfig");
        this.m_eventIpcManager.addEventListener((EventListener)this, "uei.opennms.org/internal/reloadDaemonConfigFailed");
        this.readConfiguration();
        this.registerEngines();
    }

    private void registerEngines() {
        for (PluginConfiguration pluginConfig : this.m_pluginConfigurations) {
            this.m_correlator.addCorrelationEngines(pluginConfig.constructEngines(this.m_appContext, this.m_eventIpcManager, this.m_metricRegistry));
        }
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.m_metricRegistry = metricRegistry;
    }

    public void setConfigurationResource(org.springframework.core.io.Resource configResource) {
        this.m_configResource = configResource;
    }

    public void setConfigurationDirectory(File configDirectory) {
        this.m_configDirectory = configDirectory;
    }

    public void setCorrelationEngineRegistrar(CorrelationEngineRegistrar correlator) {
        this.m_correlator = correlator;
    }

    private void readConfiguration() throws Exception {
        for (PluginConfiguration pluginCofig : this.m_pluginConfigurations = this.locatePluginConfigurations()) {
            pluginCofig.readConfig();
        }
    }

    private PluginConfiguration[] locatePluginConfigurations() throws Exception {
        File[] pluginDirs;
        LinkedList<PluginConfiguration> pluginConfigs = new LinkedList<PluginConfiguration>();
        if (this.m_configResource != null && this.m_configResource.isReadable()) {
            LOG.info("Found Drools Plugin config file {}.", (Object)this.m_configResource);
            pluginConfigs.add(new PluginConfiguration(this.m_configResource));
        }
        for (File pluginDir : pluginDirs = this.getPluginDirs()) {
            File configFile = new File(pluginDir, PLUGIN_CONFIG_FILE_NAME);
            if (!configFile.exists()) {
                LOG.error("Drools Plugin directory {} does not contains a {} config file.  Ignoring plugin.", (Object)pluginDir, (Object)PLUGIN_CONFIG_FILE_NAME);
                continue;
            }
            LOG.info("Found Drools Plugin directory {} containing a {} config file.", (Object)pluginDir, (Object)PLUGIN_CONFIG_FILE_NAME);
            pluginConfigs.add(new PluginConfiguration((org.springframework.core.io.Resource)new FileSystemResource(configFile)));
        }
        return pluginConfigs.toArray(new PluginConfiguration[0]);
    }

    private File[] getPluginDirs() throws Exception {
        LOG.debug("Checking {} for drools correlation plugins", (Object)this.m_configDirectory);
        if (!this.m_configDirectory.exists()) {
            LOG.debug("Plugin configuration directory does not exists.");
            return new File[0];
        }
        File[] pluginDirs = this.m_configDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        LOG.debug("Found {} drools correlation plugin sub directories", (Object)pluginDirs.length);
        return pluginDirs;
    }

    public String getName() {
        return "DroolsCorrelationEngine";
    }

    public void onEvent(Event e) {
        String daemonName;
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig") && (daemonName = this.getDaemonNameFromReloadDaemonEvent(e)) != null && daemonName.equals(this.getName())) {
            this.doAddAndRemoveEngines();
            return;
        }
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfigFailed")) {
            daemonName = this.getDaemonNameFromReloadDaemonEvent(e);
            Matcher m = Pattern.compile(this.getName() + "-(.+)$").matcher(daemonName);
            if (m.find()) {
                String engineName = m.group(1);
                LOG.warn("An error was detected while reloading engine {}, this engine will be removed. Fix the error and try again.", (Object)engineName);
                this.m_correlator.removeCorrelationEngine(engineName);
                for (PluginConfiguration p : this.m_pluginConfigurations) {
                    RuleSet set = p.getRuleSets().stream().filter(r -> r.getName().equals(engineName)).findFirst().orElse(null);
                    if (set == null) continue;
                    p.getRuleSets().remove(set);
                }
            }
        }
    }

    private String getDaemonNameFromReloadDaemonEvent(Event e) {
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            String parmName = parm.getParmName();
            if (!"daemonName".equals(parmName)) continue;
            if (parm.getValue() == null || parm.getValue().getContent() == null) {
                LOG.warn("The daemonName parameter has no value, ignoring.");
                return null;
            }
            return parm.getValue().getContent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddAndRemoveEngines() {
        LOG.info("Analyzing directory {} to add/remove drools engines...", (Object)this.m_configDirectory);
        EventBuilder ebldr = null;
        try {
            PluginConfiguration[] newPlugins = this.locatePluginConfigurations();
            List newEngines = Arrays.stream(newPlugins).peek(p -> p.readConfig()).flatMap(pc -> pc.getRuleSets().stream()).collect(Collectors.toList());
            List currentEngines = Arrays.stream(this.m_pluginConfigurations).flatMap(pc -> pc.getRuleSets().stream()).collect(Collectors.toList());
            LOG.debug("Current engines: {}", currentEngines);
            LOG.debug("New engines: {}", newEngines);
            currentEngines.stream().filter(en -> !newEngines.contains(en)).forEach(en -> {
                LOG.warn("Deleting engine {}", en);
                this.m_correlator.removeCorrelationEngine(en.getName());
            });
            newEngines.stream().filter(en -> !currentEngines.contains(en)).forEach(en -> {
                LOG.warn("Adding engine {}", en);
                this.addEngine(newPlugins, (RuleSet)en);
            });
            this.m_pluginConfigurations = newPlugins;
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", this.getName());
        }
        catch (Exception ex) {
            LOG.error("Cannot process reloadDaemonConfig", (Throwable)ex);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", this.getName());
            ebldr.addParam("reason", ex.getMessage());
        }
        finally {
            if (ebldr != null) {
                try {
                    this.m_eventIpcManager.send(ebldr.getEvent());
                }
                catch (EventProxyException epx) {
                    LOG.error("Can't send reloadDaemonConfig status event", (Throwable)epx);
                }
            }
        }
    }

    private void addEngine(PluginConfiguration[] newPlugins, RuleSet ruleSet) {
        Arrays.stream(newPlugins).filter(p -> p.getRuleSets().contains(ruleSet)).findFirst().ifPresent(p -> {
            try {
                LOG.debug("addEngine: adding engine {} using {}", (Object)ruleSet.getName(), (Object)p.getConfigResource());
                this.m_correlator.addCorrelationEngine(ruleSet.constructEngine(p.getConfigResource(), this.m_appContext, this.m_eventIpcManager, this.m_metricRegistry));
            }
            catch (Exception e) {
                p.getRuleSets().remove(ruleSet);
            }
        });
    }

    private static class PluginConfiguration {
        private org.springframework.core.io.Resource m_configResource;
        private EngineConfiguration m_configuration;

        public PluginConfiguration(org.springframework.core.io.Resource configResource) {
            this.m_configResource = configResource;
        }

        public void readConfig() {
            LOG.info("Parsing drools engine configuration at {}.", (Object)this.m_configResource);
            this.m_configuration = (EngineConfiguration)JaxbUtils.unmarshal(EngineConfiguration.class, (org.springframework.core.io.Resource)this.m_configResource);
        }

        public CorrelationEngine[] constructEngines(ApplicationContext appContext, EventIpcManager eventIpcManager, MetricRegistry metricRegistry) {
            LOG.info("Creating drools engines for configuration {}.", (Object)this.m_configResource);
            return this.m_configuration.constructEngines(this.m_configResource, appContext, eventIpcManager, metricRegistry);
        }

        public List<RuleSet> getRuleSets() {
            if (this.m_configuration == null) {
                return Collections.emptyList();
            }
            return this.m_configuration.getRuleSetCollection();
        }

        public org.springframework.core.io.Resource getConfigResource() {
            return this.m_configResource;
        }
    }
}

