/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.RuleBaseConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.opennms.netmgt.correlation.AbstractCorrelationEngine;
import org.opennms.netmgt.correlation.drools.TimerExpired;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DroolsCorrelationEngine
extends AbstractCorrelationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsCorrelationEngine.class);
    private KieSession m_kieSession;
    private List<String> m_interestingEvents;
    private List<Resource> m_rules;
    private Map<String, Object> m_globals = new HashMap<String, Object>();
    private String m_name;
    private String m_assertBehaviour;
    private String m_eventProcessingMode;

    public synchronized void correlate(Event e) {
        LOG.debug("Begin correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
        this.m_kieSession.insert((Object)e);
        this.m_kieSession.fireAllRules();
        LOG.debug("End correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
    }

    protected synchronized void timerExpired(Integer timerId) {
        LOG.info("Begin correlation for Timer {}", (Object)timerId);
        TimerExpired expiration = new TimerExpired(timerId);
        this.m_kieSession.insert((Object)expiration);
        this.m_kieSession.fireAllRules();
        LOG.debug("Begin correlation for Timer {}", (Object)timerId);
    }

    public List<String> getInterestingEvents() {
        return this.m_interestingEvents;
    }

    public void setInterestingEvents(List<String> ueis) {
        this.m_interestingEvents = ueis;
    }

    public void setRulesResources(List<Resource> rules) {
        this.m_rules = rules;
    }

    public void setGlobals(Map<String, Object> globals) {
        this.m_globals = globals;
    }

    public void initialize() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kFileSystem = ks.newKieFileSystem();
        this.loadRules(kFileSystem);
        KieBuilder kbuilder = ks.newKieBuilder(kFileSystem);
        kbuilder.buildAll();
        if (kbuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            LOG.warn("Unable to initialize Drools engine: {}", (Object)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
            throw new IllegalStateException("Unable to initialize Drools engine: " + kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        KieContainer kContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        RuleBaseConfiguration.AssertBehaviour behaviour = RuleBaseConfiguration.AssertBehaviour.determineAssertBehaviour((String)this.m_assertBehaviour);
        RuleBaseConfiguration ruleBaseConfig = new RuleBaseConfiguration();
        ruleBaseConfig.setAssertBehaviour(behaviour);
        EventProcessingOption eventProcessingOption = EventProcessingOption.CLOUD;
        if (this.m_eventProcessingMode != null && this.m_eventProcessingMode.toLowerCase().equals("stream")) {
            eventProcessingOption = EventProcessingOption.STREAM;
        }
        ruleBaseConfig.setEventProcessingMode(eventProcessingOption);
        KieBase kieBase = kContainer.newKieBase((KieBaseConfiguration)ruleBaseConfig);
        this.m_kieSession = kieBase.newKieSession();
        this.m_kieSession.setGlobal("engine", (Object)this);
        for (Map.Entry<String, Object> entry : this.m_globals.entrySet()) {
            this.m_kieSession.setGlobal(entry.getKey(), entry.getValue());
        }
    }

    private void loadRules(KieFileSystem kfs) throws DroolsParserException, IOException {
        int k = 0;
        for (Resource rulesFile : this.m_rules) {
            InputStream is = rulesFile.getInputStream();
            Throwable throwable = null;
            try {
                LOG.debug("Loading rules file: {}", (Object)rulesFile);
                kfs.write(String.format("src/main/resources/" + rulesFile.getFilename(), ++k), ByteStreams.toByteArray((InputStream)is));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public Collection<? extends Object> getKieSessionObjects() {
        return this.m_kieSession.getObjects();
    }

    public KieSession getKieSession() {
        return this.m_kieSession;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setGlobal(String name, Object value) {
        this.m_kieSession.setGlobal(name, value);
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this.m_assertBehaviour = assertBehaviour;
    }

    public String getEventProcessingMode() {
        return this.m_eventProcessingMode;
    }

    public void setEventProcessingMode(String eventProcessingMode) {
        this.m_eventProcessingMode = eventProcessingMode;
    }
}

