/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.RuleBaseConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.opennms.core.logging.Logging;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.correlation.AbstractCorrelationEngine;
import org.opennms.netmgt.correlation.drools.TimerExpired;
import org.opennms.netmgt.correlation.drools.config.EngineConfiguration;
import org.opennms.netmgt.correlation.drools.config.RuleSet;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class DroolsCorrelationEngine
extends AbstractCorrelationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsCorrelationEngine.class);
    private KieBase m_kieBase;
    private KieSession m_kieSession;
    private List<String> m_interestingEvents;
    private List<Resource> m_rules;
    private Map<String, Object> m_globals = new HashMap<String, Object>();
    private String m_name;
    private String m_assertBehaviour;
    private String m_eventProcessingMode;
    private boolean m_isStreaming = false;
    private final Meter m_eventsMeter;
    private MetricRegistry m_metricRegistry;
    private Boolean m_persistState;
    private Resource m_configPath;
    private ApplicationContext m_configContext;

    public DroolsCorrelationEngine(String name, MetricRegistry metricRegistry, Resource configPath, ApplicationContext configContext) {
        this.m_name = name;
        this.m_configPath = configPath;
        this.m_configContext = configContext;
        this.m_metricRegistry = metricRegistry;
        Gauge factCount = () -> this.getKieSession().getFactCount();
        metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[]{"fact-count"}), (Metric)factCount);
        Gauge pendingTasksCount = () -> this.getPendingTasksCount();
        metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[]{"pending-tasks-count"}), (Metric)pendingTasksCount);
        this.m_eventsMeter = metricRegistry.meter(MetricRegistry.name((String)name, (String[])new String[]{"events"}));
    }

    public Resource getConfigPath() {
        return this.m_configPath;
    }

    public ApplicationContext getConfigContext() {
        return this.m_configContext;
    }

    public synchronized void correlate(Event e) {
        LOG.debug("Begin correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
        this.m_kieSession.insert((Object)e);
        try {
            if (!this.m_isStreaming) {
                this.m_kieSession.fireAllRules();
            }
        }
        catch (Exception e1) {
            LOG.error("Exception while firing rules ", (Throwable)e1);
        }
        this.m_eventsMeter.mark();
        LOG.debug("End correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
    }

    protected synchronized void timerExpired(Integer timerId) {
        LOG.info("Begin correlation for Timer {}", (Object)timerId);
        TimerExpired expiration = new TimerExpired(timerId);
        this.m_kieSession.insert((Object)expiration);
        try {
            if (!this.m_isStreaming) {
                this.m_kieSession.fireAllRules();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while firing rules ", (Throwable)e);
        }
        LOG.debug("Begin correlation for Timer {}", (Object)timerId);
    }

    public List<String> getInterestingEvents() {
        return this.m_interestingEvents;
    }

    public void setInterestingEvents(List<String> ueis) {
        this.m_interestingEvents = ueis;
    }

    public void setRulesResources(List<Resource> rules) {
        this.m_rules = rules;
    }

    public void setGlobals(Map<String, Object> globals) {
        this.m_globals = globals;
    }

    public void initialize() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kFileSystem = ks.newKieFileSystem();
        this.loadRules(kFileSystem);
        KieBuilder kbuilder = ks.newKieBuilder(kFileSystem);
        kbuilder.buildAll();
        if (kbuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            LOG.warn("Unable to initialize Drools engine: {}", (Object)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
            throw new IllegalStateException("Unable to initialize Drools engine: " + kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        KieContainer kContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        RuleBaseConfiguration.AssertBehaviour behaviour = RuleBaseConfiguration.AssertBehaviour.determineAssertBehaviour((String)this.m_assertBehaviour);
        RuleBaseConfiguration ruleBaseConfig = new RuleBaseConfiguration();
        ruleBaseConfig.setAssertBehaviour(behaviour);
        EventProcessingOption eventProcessingOption = EventProcessingOption.CLOUD;
        if (this.m_eventProcessingMode != null && this.m_eventProcessingMode.toLowerCase().equals("stream")) {
            eventProcessingOption = EventProcessingOption.STREAM;
            this.m_isStreaming = true;
        }
        ruleBaseConfig.setEventProcessingMode(eventProcessingOption);
        this.m_kieBase = kContainer.newKieBase((KieBaseConfiguration)ruleBaseConfig);
        this.m_kieSession = this.m_kieBase.newKieSession();
        this.m_kieSession.setGlobal("engine", (Object)this);
        for (Map.Entry<String, Object> entry : this.m_globals.entrySet()) {
            this.m_kieSession.setGlobal(entry.getKey(), entry.getValue());
        }
        if (this.m_persistState != null && this.m_persistState.booleanValue()) {
            this.unmarshallStateFromDisk(true);
        }
        if (this.m_isStreaming) {
            new Thread(() -> {
                Logging.putPrefix((String)(((Object)((Object)this)).getClass().getSimpleName() + '-' + this.getName()));
                try {
                    this.m_kieSession.fireUntilHalt();
                }
                catch (Exception e) {
                    LOG.error("Exception while running rules, reloading engine ", (Throwable)e);
                    this.triggerAlarm(e);
                    this.reloadConfig();
                }
            }, "FireTask").start();
        }
    }

    private void triggerAlarm(Exception exception) {
        EventBuilder eventBldr = new EventBuilder("uei.opennms.org/internal/droolsEngineException", this.getName());
        eventBldr.addParam("enginename", this.getName());
        eventBldr.addParam("stracktrace", ExceptionUtils.getStackTrace((Throwable)exception));
        this.sendEvent(eventBldr.getEvent());
    }

    private void loadRules(KieFileSystem kfs) throws DroolsParserException, IOException {
        int k = 0;
        for (Resource rulesFile : this.m_rules) {
            InputStream is = rulesFile.getInputStream();
            Throwable throwable = null;
            try {
                LOG.debug("Loading rules file: {}", (Object)rulesFile);
                kfs.write(String.format("src/main/resources/" + rulesFile.getFilename(), ++k), ByteStreams.toByteArray((InputStream)is));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public void tearDown() {
        this.getScheduler().shutdown();
        this.m_metricRegistry.remove(MetricRegistry.name((String)this.getName(), (String[])new String[]{"pending-tasks-count"}));
        this.m_metricRegistry.remove(MetricRegistry.name((String)this.getName(), (String[])new String[]{"fact-count"}));
        this.m_metricRegistry.remove(MetricRegistry.name((String)this.getName(), (String[])new String[]{"events"}));
        if (this.m_persistState != null && this.m_persistState.booleanValue()) {
            if (this.getPendingTasksCount() > 0) {
                LOG.error("Cannot marshall state because there are pending time based tasks running.");
                this.shutDownKieSession();
            } else {
                this.marshallStateToDisk(true);
            }
        } else {
            this.shutDownKieSession();
        }
    }

    private void shutDownKieSession() {
        this.m_kieSession.halt();
        this.m_kieSession.dispose();
        this.m_kieSession.destroy();
    }

    private Path getPathToState() {
        return Paths.get(System.getProperty("java.io.tmpdir"), "opennms.drools." + this.m_name + ".state");
    }

    private void marshallStateToDisk(boolean serialize) {
        File stateFile = this.getPathToState().toFile();
        LOG.debug("Saving state for engine {} in {} ...", (Object)this.m_name, (Object)stateFile);
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = serialize ? kMarshallers.newSerializeMarshallingStrategy() : kMarshallers.newIdentityMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(this.m_kieBase, new ObjectMarshallingStrategy[]{oms});
        try (FileOutputStream fos = new FileOutputStream(stateFile);){
            this.m_kieSession.halt();
            marshaller.marshall((OutputStream)fos, this.m_kieSession);
            this.m_kieSession.dispose();
            this.m_kieSession.destroy();
            LOG.info("Sucessfully save state for engine {} in {}.", (Object)this.m_name, (Object)stateFile);
        }
        catch (IOException e) {
            LOG.error("Failed to save state for engine {} in {}.", new Object[]{this.m_name, stateFile, e});
        }
    }

    private void unmarshallStateFromDisk(boolean serialize) {
        File stateFile = this.getPathToState().toFile();
        if (!stateFile.exists()) {
            LOG.error("Can't restore state from {} because the file doesn't exist", (Object)stateFile);
            return;
        }
        LOG.debug("Restoring state for engine {} from {} ...", (Object)this.m_name, (Object)stateFile);
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = serialize ? kMarshallers.newSerializeMarshallingStrategy() : kMarshallers.newIdentityMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(this.m_kieBase, new ObjectMarshallingStrategy[]{oms});
        try (FileInputStream fin = new FileInputStream(stateFile);){
            marshaller.unmarshall((InputStream)fin, this.m_kieSession);
            stateFile.delete();
            LOG.info("Sucessfully restored state for engine {} from {}.", (Object)this.m_name, (Object)stateFile);
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Failed to restore state for engine {} from {}.", new Object[]{this.m_name, stateFile, e});
        }
    }

    public Collection<? extends Object> getKieSessionObjects() {
        return this.m_kieSession.getObjects();
    }

    public KieSession getKieSession() {
        return this.m_kieSession;
    }

    public String getName() {
        return this.m_name;
    }

    public void setGlobal(String name, Object value) {
        this.m_kieSession.setGlobal(name, value);
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this.m_assertBehaviour = assertBehaviour;
    }

    public String getEventProcessingMode() {
        return this.m_eventProcessingMode;
    }

    public void setEventProcessingMode(String eventProcessingMode) {
        this.m_eventProcessingMode = eventProcessingMode;
    }

    public void setPersistState(Boolean persistState) {
        this.m_persistState = persistState;
    }

    public Boolean getPersistState() {
        return this.m_persistState;
    }

    public String toString() {
        return String.format("DroolsCorrelationEngine[%s]", this.m_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfig() {
        EventBuilder ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
        ebldr.addParam("daemonName", "DroolsCorrelationEngine-" + this.m_name);
        try {
            LOG.info("Reloading configuration for engine {}", (Object)this.m_name);
            EngineConfiguration cfg = (EngineConfiguration)JaxbUtils.unmarshal(EngineConfiguration.class, (Resource)this.m_configPath);
            Optional<RuleSet> opt = cfg.getRuleSetCollection().stream().filter(rs -> rs.getName().equals(this.getName())).findFirst();
            if (opt.isPresent()) {
                this.marshallStateToDisk(true);
                opt.get().updateEngine(this);
                this.initialize();
            } else {
                ebldr.setUei("uei.opennms.org/internal/reloadDaemonConfigFailed");
                ebldr.addParam("reason", "RuleSet not found on " + this.m_configPath);
            }
        }
        catch (Exception e) {
            ebldr.setUei("uei.opennms.org/internal/reloadDaemonConfigFailed");
            ebldr.addParam("reason", e.getMessage());
        }
        finally {
            this.sendEvent(ebldr.getEvent());
        }
    }
}

