/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemory;
import org.kie.api.conf.EventProcessingOption;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.correlation.AbstractCorrelationEngine;
import org.opennms.netmgt.correlation.drools.TimerExpired;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DroolsCorrelationEngine
extends AbstractCorrelationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsCorrelationEngine.class);
    private StatefulSession m_workingMemory;
    private List<String> m_interestingEvents;
    private List<Resource> m_rules;
    private Map<String, Object> m_globals = new HashMap<String, Object>();
    private String m_name;
    private String m_assertBehaviour;
    private String m_eventProcessingMode;
    private final Meter m_eventsMeter;
    private boolean m_isStreaming = false;

    public DroolsCorrelationEngine(String name, MetricRegistry metricRegistry) {
        this.m_name = name;
        Gauge factCount = () -> this.getWorkingMemory().getFactCount();
        metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[]{"fact-count"}), (Metric)factCount);
        Gauge pendingTasksCount = () -> this.getPendingTasksCount();
        metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[]{"pending-tasks-count"}), (Metric)pendingTasksCount);
        this.m_eventsMeter = metricRegistry.meter(MetricRegistry.name((String)name, (String[])new String[]{"events"}));
    }

    public synchronized void correlate(Event e) {
        LOG.debug("Begin correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
        this.m_workingMemory.insert((Object)e);
        if (!this.m_isStreaming) {
            this.m_workingMemory.fireAllRules();
        }
        this.m_eventsMeter.mark();
        LOG.debug("End correlation for Event {} uei: {}", (Object)e.getDbid(), (Object)e.getUei());
    }

    protected synchronized void timerExpired(Integer timerId) {
        LOG.info("Begin correlation for Timer {}", (Object)timerId);
        TimerExpired expiration = new TimerExpired(timerId);
        this.m_workingMemory.insert((Object)expiration);
        if (!this.m_isStreaming) {
            this.m_workingMemory.fireAllRules();
        }
        LOG.debug("Begin correlation for Timer {}", (Object)timerId);
    }

    public List<String> getInterestingEvents() {
        return this.m_interestingEvents;
    }

    public void setInterestingEvents(List<String> ueis) {
        this.m_interestingEvents = ueis;
    }

    public void setRulesResources(List<Resource> rules) {
        this.m_rules = rules;
    }

    public void setGlobals(Map<String, Object> globals) {
        this.m_globals = globals;
    }

    public void initialize() throws Exception {
        Properties props = new Properties();
        props.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        PackageBuilderConfiguration packageBuilderConfig = new PackageBuilderConfiguration(props);
        PackageBuilder builder = new PackageBuilder(packageBuilderConfig);
        this.loadRules(builder);
        RuleBaseConfiguration.AssertBehaviour behaviour = RuleBaseConfiguration.AssertBehaviour.determineAssertBehaviour((String)this.m_assertBehaviour);
        RuleBaseConfiguration ruleBaseConfig = new RuleBaseConfiguration();
        ruleBaseConfig.setAssertBehaviour(behaviour);
        EventProcessingOption eventProcessingOption = EventProcessingOption.CLOUD;
        if (this.m_eventProcessingMode != null && this.m_eventProcessingMode.toLowerCase().equals("stream")) {
            eventProcessingOption = EventProcessingOption.STREAM;
            this.m_isStreaming = true;
        }
        ruleBaseConfig.setEventProcessingMode(eventProcessingOption);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfig);
        if (builder.hasErrors()) {
            LOG.warn("Unable to initialize Drools engine: {}", (Object)builder.getErrors());
            throw new IllegalStateException("Unable to initialize Drools engine: " + builder.getErrors());
        }
        ruleBase.addPackage(builder.getPackage());
        this.m_workingMemory = ruleBase.newStatefulSession();
        this.m_workingMemory.setGlobal("engine", (Object)this);
        for (Map.Entry<String, Object> entry : this.m_globals.entrySet()) {
            this.m_workingMemory.setGlobal(entry.getKey(), entry.getValue());
        }
        if (this.m_isStreaming) {
            new Thread(() -> {
                Logging.putPrefix((String)(((Object)((Object)this)).getClass().getSimpleName() + '-' + this.getName()));
                this.m_workingMemory.fireUntilHalt();
            }, "FireTask").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRules(PackageBuilder builder) throws DroolsParserException, IOException {
        for (Resource rulesFile : this.m_rules) {
            InputStreamReader rdr = null;
            try {
                LOG.debug("Loading rules file: {}", (Object)rulesFile);
                rdr = new InputStreamReader(rulesFile.getInputStream(), "UTF-8");
                builder.addPackageFromDrl((Reader)rdr);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rdr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)rdr);
        }
    }

    public int getMemorySize() {
        int count = 0;
        Iterator it = this.m_workingMemory.iterateObjects();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public List<Object> getMemoryObjects() {
        LinkedList<Object> objects = new LinkedList<Object>();
        Iterator it = this.m_workingMemory.iterateObjects();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        return objects;
    }

    public WorkingMemory getWorkingMemory() {
        return this.m_workingMemory;
    }

    public String getName() {
        return this.m_name;
    }

    public void setGlobal(String name, Object value) {
        this.m_workingMemory.setGlobal(name, value);
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this.m_assertBehaviour = assertBehaviour;
    }

    public String getEventProcessingMode() {
        return this.m_eventProcessingMode;
    }

    public void setEventProcessingMode(String eventProcessingMode) {
        this.m_eventProcessingMode = eventProcessingMode;
    }
}

