/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class ConfigFileApplicationContext
extends AbstractXmlApplicationContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileApplicationContext.class);
    private Resource m_resource;
    private String m_configFileLocation;

    public ConfigFileApplicationContext(Resource basePath, String configFileLocation, ApplicationContext parent) {
        super(parent);
        this.m_resource = basePath;
        this.m_configFileLocation = configFileLocation;
        this.refresh();
    }

    protected String[] getConfigLocations() {
        if (this.m_configFileLocation == null) {
            return null;
        }
        return new String[]{this.m_configFileLocation};
    }

    protected Resource getResourceByPath(String path) {
        try {
            return this.m_resource.createRelative(path);
        }
        catch (IOException e) {
            LOG.error("Unable to create resource for path {} relative the directory of {}", new Object[]{path, this.m_resource, e});
            throw new IllegalArgumentException("Failed to create relative path for " + path);
        }
    }
}

