/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.correlation.drools.DroolsCorrelationEngine;
import org.opennms.netmgt.correlation.drools.config.EngineConfiguration;
import org.opennms.netmgt.correlation.drools.config.Global;
import org.opennms.netmgt.correlation.drools.config.RuleSet;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class DroolsCorrelationEngineBuilder
extends PropertyEditorRegistrySupport
implements InitializingBean,
ApplicationListener<ApplicationEvent> {
    private Resource m_configResource;
    private EventIpcManager m_eventIpcManager;
    private List<RuleSetConfiguration> m_ruleSets;
    private CorrelationEngineRegistrar m_correlator;

    public DroolsCorrelationEngineBuilder() {
        this.registerDefaultEditors();
    }

    public void assertSet(Object obj, String name) {
        Assert.state((obj != null ? 1 : 0) != 0, (String)(name + " required for DroolsEngineFactoryBean"));
    }

    public void afterPropertiesSet() throws Exception {
        this.assertSet(this.m_configResource, "configurationResource");
        this.assertSet(this.m_eventIpcManager, "eventIpcManager");
        this.assertSet(this.m_correlator, "correlator");
        this.readConfiguration();
    }

    private void registerEngines(ApplicationContext appContext) {
        for (RuleSetConfiguration ruleSet : this.m_ruleSets) {
            this.m_correlator.addCorrelationEngine(ruleSet.constructEngine(appContext));
        }
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setConfigurationResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public void setCorrelationEngineRegistrar(CorrelationEngineRegistrar correlator) {
        this.m_correlator = correlator;
    }

    private void readConfiguration() throws Exception {
        EngineConfiguration configuration = (EngineConfiguration)CastorUtils.unmarshal(EngineConfiguration.class, (Resource)this.m_configResource);
        LinkedList<RuleSetConfiguration> ruleSets = new LinkedList<RuleSetConfiguration>();
        for (RuleSet ruleSet : configuration.getRuleSet()) {
            ruleSets.add(new RuleSetConfiguration(ruleSet));
        }
        this.m_ruleSets = ruleSets;
    }

    public void onApplicationEvent(ApplicationEvent appEvent) {
        ApplicationContext appContext;
        if (appEvent instanceof ContextRefreshedEvent && !((appContext = ((ContextRefreshedEvent)appEvent).getApplicationContext()) instanceof ConfigFileApplicationContext)) {
            this.registerEngines(appContext);
        }
    }

    public class RuleSetConfiguration {
        private final String m_name;
        private final String m_appContextLocation;
        private final List<String> m_interestingEvents;
        private final List<ResourceConfiguration> m_resourceConfigurations;
        private final List<GlobalConfiguration> m_globalConfig;

        public RuleSetConfiguration(RuleSet ruleSet) {
            this.m_name = ruleSet.getName();
            this.m_interestingEvents = Arrays.asList(ruleSet.getEvent());
            this.m_resourceConfigurations = new LinkedList<ResourceConfiguration>();
            for (String resourcePath : ruleSet.getRuleFile()) {
                this.m_resourceConfigurations.add(new ResourceConfiguration(resourcePath));
            }
            this.m_appContextLocation = ruleSet.getAppContext();
            this.m_globalConfig = new LinkedList<GlobalConfiguration>();
            for (Global global : ruleSet.getGlobal()) {
                this.m_globalConfig.add(new GlobalConfiguration(global));
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Map<String, Object> getGlobals(ApplicationContext context) {
            HashMap<String, Object> globals = new HashMap<String, Object>();
            for (GlobalConfiguration globalConfig : this.m_globalConfig) {
                globals.put(globalConfig.getName(), globalConfig.constructValue(context));
            }
            return globals;
        }

        public List<String> getInterestingEvents() {
            return this.m_interestingEvents;
        }

        public List<Resource> getRuleResources(ResourceLoader resourceLoader) {
            LinkedList<Resource> resources = new LinkedList<Resource>();
            for (ResourceConfiguration resConfig : this.m_resourceConfigurations) {
                resources.add(resConfig.getResource(resourceLoader));
            }
            return resources;
        }

        CorrelationEngine constructEngine(ApplicationContext parent) {
            ConfigFileApplicationContext configContext = new ConfigFileApplicationContext(this.getConfigLocation(), parent);
            DroolsCorrelationEngine engine = new DroolsCorrelationEngine();
            engine.setName(this.getName());
            engine.setEventIpcManager(DroolsCorrelationEngineBuilder.this.m_eventIpcManager);
            engine.setScheduler(new Timer(this.getName() + "-Timer"));
            engine.setInterestingEvents(this.getInterestingEvents());
            engine.setRulesResources(this.getRuleResources((ResourceLoader)configContext));
            engine.setGlobals(this.getGlobals((ApplicationContext)configContext));
            try {
                engine.initialize();
                return engine;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to initialize Drools engine " + this.getName(), e);
            }
        }

        private String getConfigLocation() {
            return PropertiesUtils.substitute((String)this.m_appContextLocation, (Properties[])new Properties[]{System.getProperties()});
        }
    }

    public static class GlobalConfiguration
    extends PropertyEditorRegistrySupport {
        private final String m_name;
        private final String m_type;
        private final String m_value;
        private final String m_ref;

        public GlobalConfiguration(Global global) {
            this.registerDefaultEditors();
            this.m_name = global.getName();
            this.m_type = global.getType();
            this.m_value = global.getValue();
            this.m_ref = global.getRef();
        }

        public String getName() {
            return this.m_name;
        }

        public String getRef() {
            return this.m_ref;
        }

        public String getType() {
            return this.m_type;
        }

        public String getValue() {
            return this.m_value;
        }

        Object constructValue(ApplicationContext context) {
            String value;
            String type = this.getType();
            Class typeClass = Object.class;
            if (type != null) {
                PropertyEditor classEditor = this.getDefaultEditor(Class.class);
                classEditor.setAsText(type);
                typeClass = (Class)classEditor.getValue();
            }
            if ((value = this.getValue()) != null) {
                if (typeClass == String.class) {
                    return value;
                }
                try {
                    PropertyEditor valueEditor = this.getDefaultEditor(typeClass);
                    valueEditor.setAsText(value);
                    return valueEditor.getValue();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to find a property editor for " + typeClass);
                }
            }
            String ref = this.getRef();
            if (ref != null) {
                return context.getBean(ref, typeClass);
            }
            throw new IllegalArgumentException("One of either the value or the ref must be specified");
        }
    }

    public static class ResourceConfiguration {
        private String m_resourcePath;

        public ResourceConfiguration(String resourcePath) {
            this.m_resourcePath = resourcePath;
        }

        public Resource getResource(ResourceLoader loader) {
            String finalName = PropertiesUtils.substitute((String)this.m_resourcePath, (Properties[])new Properties[]{System.getProperties()});
            return loader.getResource(finalName);
        }
    }

    private static class ConfigFileApplicationContext
    extends AbstractXmlApplicationContext {
        private String m_configFileLocation;

        public ConfigFileApplicationContext(String configFileLocation, ApplicationContext parent) {
            super(parent);
            this.m_configFileLocation = configFileLocation;
            this.refresh();
        }

        protected String[] getConfigLocations() {
            if (this.m_configFileLocation == null) {
                return null;
            }
            return new String[]{this.m_configFileLocation};
        }

        protected Resource getResourceByPath(String path) {
            return new FileSystemResource(path);
        }
    }
}

