/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.opennms.shaded.org.bouncycastle.asn1.BERGenerator;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream outputStream, int n, boolean bl) throws IOException {
        super(outputStream, n, bl);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return this.getOctetOutputStream(new byte[1000]);
    }

    public OutputStream getOctetOutputStream(byte[] byArray) {
        return new BufferedBEROctetStream(byArray);
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;

        BufferedBEROctetStream(byte[] byArray) {
            this._buf = byArray;
            this._off = 0;
        }

        public void write(int n) throws IOException {
            this._buf[this._off++] = (byte)n;
            if (this._off == this._buf.length) {
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(n2, this._buf.length - this._off);
                System.arraycopy(byArray, n, this._buf, this._off, n3);
                this._off += n3;
                if (this._off < this._buf.length) break;
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
                n += n3;
                n2 -= n3;
            }
        }

        public void close() throws IOException {
            if (this._off != 0) {
                byte[] byArray = new byte[this._off];
                System.arraycopy(this._buf, 0, byArray, 0, this._off);
                BEROctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

