/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import org.opennms.shaded.org.bouncycastle.crypto.engines.AESFastEngine;
import org.opennms.shaded.org.bouncycastle.crypto.engines.DESedeEngine;
import org.opennms.shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsBlockCipherCipherSuite;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsCipherSuiteManager {
    private static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    private static final int TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    private static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    private static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    private static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    private static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    private static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    private static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    private static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;

    protected static void writeCipherSuites(OutputStream outputStream) throws IOException {
        int[] nArray = new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
        TlsUtils.writeUint16(2 * nArray.length, outputStream);
        for (int i = 0; i < nArray.length; ++i) {
            TlsUtils.writeUint16(nArray[i], outputStream);
        }
    }

    protected static TlsCipherSuite getCipherSuite(int n, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        switch (n) {
            case 10: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)1);
            }
            case 19: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)3);
            }
            case 22: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)5);
            }
            case 47: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)1);
            }
            case 50: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)3);
            }
            case 51: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)5);
            }
            case 53: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)1);
            }
            case 56: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)3);
            }
            case 57: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)5);
            }
        }
        tlsProtocolHandler.failWithError((short)2, (short)40);
        return null;
    }

    private static TlsCipherSuite createAESCipherSuite(int n, short s) {
        return new TlsBlockCipherCipherSuite(TlsCipherSuiteManager.createAESCipher(), TlsCipherSuiteManager.createAESCipher(), new SHA1Digest(), new SHA1Digest(), n, s);
    }

    private static TlsCipherSuite createDESedeCipherSuite(int n, short s) {
        return new TlsBlockCipherCipherSuite(TlsCipherSuiteManager.createDESedeCipher(), TlsCipherSuiteManager.createDESedeCipher(), new SHA1Digest(), new SHA1Digest(), n, s);
    }

    private static CBCBlockCipher createAESCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    private static CBCBlockCipher createDESedeCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }
}

