/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Object;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DEROutputStream;
import org.opennms.shaded.org.bouncycastle.util.Arrays;

public class DERApplicationSpecific
extends ASN1Object {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, byte[] byArray) {
        this(false, n, byArray);
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this(true, n, dEREncodable);
    }

    public DERApplicationSpecific(boolean bl, int n, DEREncodable dEREncodable) throws IOException {
        byte[] byArray = dEREncodable.getDERObject().getDEREncoded();
        this.isConstructed = bl;
        this.tag = n;
        if (bl) {
            this.octets = byArray;
        } else {
            int n2 = this.getLengthOfLength(byArray);
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    public DERApplicationSpecific(int n, ASN1EncodableVector aSN1EncodableVector) {
        this.tag = n;
        this.isConstructed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != aSN1EncodableVector.size(); ++i) {
            try {
                byteArrayOutputStream.write(((ASN1Encodable)aSN1EncodableVector.get(i)).getEncoded());
                continue;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("malformed object: " + iOException);
            }
        }
        this.octets = byteArrayOutputStream.toByteArray();
    }

    private int getLengthOfLength(byte[] byArray) {
        int n = 2;
        while ((byArray[n - 1] & 0x80) != 0) {
            ++n;
        }
        return n;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int n) throws IOException {
        if (n >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.replaceTagNumber(n, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return new ASN1InputStream(byArray2).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        int n = 64;
        if (this.isConstructed) {
            n |= 0x20;
        }
        dEROutputStream.writeEncoded(n, this.tag, this.octets);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        return this.isConstructed == dERApplicationSpecific.isConstructed && this.tag == dERApplicationSpecific.tag && Arrays.areEqual(this.octets, dERApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    private byte[] replaceTagNumber(int n, byte[] byArray) throws IOException {
        int n2 = byArray[0] & 0x1F;
        int n3 = 1;
        if (n2 == 31) {
            int n4;
            n2 = 0;
            if (((n4 = byArray[n3++] & 0xFF) & 0x7F) == 0) {
                throw new IllegalStateException("corrupted stream - invalid high tag number found");
            }
            while (n4 >= 0 && (n4 & 0x80) != 0) {
                n2 |= n4 & 0x7F;
                n2 <<= 7;
                n4 = byArray[n3++] & 0xFF;
            }
            n2 |= n4 & 0x7F;
        }
        byte[] byArray2 = new byte[byArray.length - n3 + 1];
        System.arraycopy(byArray, n3, byArray2, 1, byArray2.length - 1);
        byArray2[0] = (byte)n;
        return byArray2;
    }
}

