/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.IOException;
import java.security.SecureRandom;
import net.jradius.tls.Arrays;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsCipher;
import net.jradius.tls.TlsMac;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.tls.TlsUtils;
import org.opennms.shaded.org.bouncycastle.crypto.BlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.Digest;
import org.opennms.shaded.org.bouncycastle.crypto.params.KeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.ParametersWithIV;

public class TlsBlockCipher
implements TlsCipher {
    private TlsProtocolHandler handler;
    private BlockCipher encryptCipher;
    private BlockCipher decryptCipher;
    private TlsMac writeMac;
    private TlsMac readMac;

    TlsBlockCipher(TlsProtocolHandler handler, BlockCipher encryptCipher, BlockCipher decryptCipher, Digest writeDigest, Digest readDigest, int cipherKeySize, SecurityParameters securityParameters) {
        this.handler = handler;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int prfSize = 2 * cipherKeySize + writeDigest.getDigestSize() + readDigest.getDigestSize() + encryptCipher.getBlockSize() + decryptCipher.getBlockSize();
        byte[] key_block = TlsUtils.PRF(securityParameters.masterSecret, "key expansion", TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom), prfSize);
        int offset = 0;
        this.writeMac = new TlsMac(writeDigest, key_block, offset, writeDigest.getDigestSize());
        this.readMac = new TlsMac(readDigest, key_block, offset += writeDigest.getDigestSize(), readDigest.getDigestSize());
        this.initCipher(true, encryptCipher, key_block, cipherKeySize, offset += readDigest.getDigestSize(), offset + cipherKeySize * 2);
        this.initCipher(false, decryptCipher, key_block, cipherKeySize, offset += cipherKeySize, offset + cipherKeySize + encryptCipher.getBlockSize());
    }

    private void initCipher(boolean forEncryption, BlockCipher cipher, byte[] key_block, int key_size, int key_offset, int iv_offset) {
        KeyParameter key_parameter = new KeyParameter(key_block, key_offset, key_size);
        ParametersWithIV parameters_with_iv = new ParametersWithIV(key_parameter, key_block, iv_offset, cipher.getBlockSize());
        cipher.init(forEncryption, parameters_with_iv);
    }

    public byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        int i;
        int blocksize = this.encryptCipher.getBlockSize();
        int minPaddingSize = blocksize - (len + this.writeMac.getSize() + 1) % blocksize;
        int maxExtraPadBlocks = (255 - minPaddingSize) / blocksize;
        int actualExtraPadBlocks = this.chooseExtraPadBlocks(this.handler.getRandom(), maxExtraPadBlocks);
        int paddingsize = minPaddingSize + actualExtraPadBlocks * blocksize;
        int totalsize = len + this.writeMac.getSize() + paddingsize + 1;
        byte[] outbuf = new byte[totalsize];
        System.arraycopy(plaintext, offset, outbuf, 0, len);
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        System.arraycopy(mac, 0, outbuf, len, mac.length);
        int paddoffset = len + mac.length;
        for (i = 0; i <= paddingsize; ++i) {
            outbuf[i + paddoffset] = (byte)paddingsize;
        }
        for (i = 0; i < totalsize; i += blocksize) {
            this.encryptCipher.processBlock(outbuf, i, outbuf, i);
        }
        return outbuf;
    }

    public byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len) throws IOException {
        int minLength = this.readMac.getSize() + 1;
        int blocksize = this.decryptCipher.getBlockSize();
        boolean decrypterror = false;
        if (len < minLength) {
            this.handler.failWithError((short)2, (short)50);
        }
        if (len % blocksize != 0) {
            this.handler.failWithError((short)2, (short)21);
        }
        for (int i = 0; i < len; i += blocksize) {
            this.decryptCipher.processBlock(ciphertext, i + offset, ciphertext, i + offset);
        }
        int lastByteOffset = offset + len - 1;
        byte paddingsizebyte = ciphertext[lastByteOffset];
        int paddingsize = paddingsizebyte & 0xFF;
        int maxPaddingSize = len - minLength;
        if (paddingsize > maxPaddingSize) {
            decrypterror = true;
            paddingsize = 0;
        } else {
            int diff = 0;
            for (int i = lastByteOffset - paddingsize; i < lastByteOffset; ++i) {
                diff = (byte)(diff | ciphertext[i] ^ paddingsizebyte);
            }
            if (diff != 0) {
                decrypterror = true;
                paddingsize = 0;
            }
        }
        int plaintextlength = len - minLength - paddingsize;
        byte[] calculatedMac = this.readMac.calculateMac(type, ciphertext, offset, plaintextlength);
        byte[] decryptedMac = new byte[calculatedMac.length];
        System.arraycopy(ciphertext, offset + plaintextlength, decryptedMac, 0, calculatedMac.length);
        if (!Arrays.constantTimeAreEqual(calculatedMac, decryptedMac)) {
            decrypterror = true;
        }
        if (decrypterror) {
            this.handler.failWithError((short)2, (short)20);
        }
        byte[] plaintext = new byte[plaintextlength];
        System.arraycopy(ciphertext, offset, plaintext, 0, plaintextlength);
        return plaintext;
    }

    private int chooseExtraPadBlocks(SecureRandom r, int max) {
        int x = r.nextInt();
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    private int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }
}

