/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.pkcs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Set;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PrivateKeyInfo
extends ASN1Encodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;
    private ASN1Set attributes;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static PrivateKeyInfo getInstance(Object object) {
        if (object instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PrivateKeyInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, DERObject dERObject) {
        this(algorithmIdentifier, dERObject, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, DERObject dERObject, ASN1Set aSN1Set) {
        this.privKey = dERObject;
        this.algId = algorithmIdentifier;
        this.attributes = aSN1Set;
    }

    public PrivateKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        BigInteger bigInteger = ((DERInteger)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.algId = new AlgorithmIdentifier((ASN1Sequence)enumeration.nextElement());
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(((ASN1OctetString)enumeration.nextElement()).getOctets());
            this.privKey = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error recoverying private key from sequence");
        }
        if (enumeration.hasMoreElements()) {
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)enumeration.nextElement(), false);
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(0));
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(new DEROctetString(this.privKey));
        if (this.attributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.attributes));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

