/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.ocsp;

import org.opennms.shaded.org.bouncycastle.asn1.ASN1Choice;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Name;

public class ResponderID
extends ASN1Encodable
implements ASN1Choice {
    private DEREncodable value;

    public ResponderID(ASN1OctetString aSN1OctetString) {
        this.value = aSN1OctetString;
    }

    public ResponderID(X509Name x509Name) {
        this.value = x509Name;
    }

    public static ResponderID getInstance(Object object) {
        if (object == null || object instanceof ResponderID) {
            return (ResponderID)object;
        }
        if (object instanceof DEROctetString) {
            return new ResponderID((DEROctetString)object);
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            if (aSN1TaggedObject.getTagNo() == 1) {
                return new ResponderID(X509Name.getInstance(aSN1TaggedObject, true));
            }
            return new ResponderID(ASN1OctetString.getInstance(aSN1TaggedObject, true));
        }
        return new ResponderID(X509Name.getInstance(object));
    }

    public static ResponderID getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponderID.getInstance(aSN1TaggedObject.getObject());
    }

    public DERObject toASN1Object() {
        if (this.value instanceof ASN1OctetString) {
            return new DERTaggedObject(true, 2, this.value);
        }
        return new DERTaggedObject(true, 1, this.value);
    }
}

