/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.session;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jradius.dictionary.Attr_AcctInputGigawords;
import net.jradius.dictionary.Attr_AcctOutputGigawords;
import net.jradius.exception.RadiusException;
import net.jradius.exception.RadiusSecurityException;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.session.RadiusSessionSupport;

public class RadiusSession
implements JRadiusSession,
Serializable {
    public static final long serialVersionUID = 0L;
    private int sessionState = 0;
    private String sessionKey;
    private String jRadiusKey;
    private boolean newSession = true;
    private long timeStamp;
    private JRadiusRequest lastRadiusRequest;
    private Map<String, JRadiusLogEntry> logEntryMap = new HashMap<String, JRadiusLogEntry>();
    private Map<String, Serializable> attributeMap = new HashMap<String, Serializable>();
    private String username;
    private String realm;
    private String password;
    private String sessionId;
    private String proxyToRealm;
    private String redirectURL;
    private boolean secured;
    private String connectInfo;
    private String callingStationId;
    private String calledStationId;
    private String nasIdentifier;
    private String nasIPAddress;
    private String clientIPAddress;
    private String framedIPAddress;
    private byte[][] radiusClass;
    private byte[] radiusState;
    private Long idleTimeout;
    private Long sessionTimeout;
    private Long interimInterval;
    private Long maxBandwidthUp;
    private Long maxBandwidthDown;
    private Long minBandwidthUp;
    private Long minBandwidthDown;
    private Long maxOctetsUp;
    private Long maxOctetsDown;
    private Long maxOctetsTotal;
    private String nasType;
    private Long nasPortType;
    private Long acctAuthentic;
    private Long serviceType;
    private Long sessionTime;
    private Long packetsIn;
    private Long packetsOut;
    private Long octetsIn;
    private Long octetsOut;
    private Long gigaWordsIn;
    private Long gigaWordsOut;
    private Long terminateCause;
    private Date authorizeTime;
    private Date startTime;
    private Date lastInterimTime;
    private Date stopTime;
    private volatile boolean locked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        RadiusSession radiusSession = this;
        synchronized (radiusSession) {
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.yield();
                }
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        RadiusSession radiusSession = this;
        synchronized (radiusSession) {
            this.locked = false;
            this.notify();
        }
    }

    public RadiusSession() {
    }

    public RadiusSession(String session) {
        this();
        this.setSessionKey(session);
        RadiusLog.debug((String)("Creating new session: " + session));
    }

    public boolean isAccountingReversed() {
        return false;
    }

    public void setAttribute(String name, Serializable value) {
        this.attributeMap.put(name, value);
    }

    public Serializable getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public boolean isLogging() {
        return true;
    }

    public JRadiusLogEntry getLogEntry(JRadiusEvent event, String key) {
        JRadiusLogEntry entry = this.logEntryMap.get(key);
        if (entry == null) {
            RadiusLog.debug((String)("Creating new Session/LogEntry: " + this.getSessionKey() + "/" + key));
            entry = JRadiusSessionManager.getManager((Object)event.getSender()).newLogEntry(event, (JRadiusSession)this, key);
            this.logEntryMap.put(key, entry);
        }
        RadiusLog.debug((String)("Retreived Session/LogEntry: " + this.getSessionKey() + "/" + key));
        entry.setLastUpdate(new Date());
        return entry;
    }

    public JRadiusLogEntry getLogEntry(JRadiusRequest request) throws RadiusException {
        AttributeList ci = request.getConfigItems();
        RadiusAttribute a = ci.get(1259012097L);
        String key = a != null ? (String)((Object)a.getValue().getValueObject()) : Integer.toString((char)request.getRequestPacket().getIdentifier());
        JRadiusLogEntry entry = this.getLogEntry((JRadiusEvent)request, key);
        entry.setCode(new Integer(request.getReturnValue()));
        return entry;
    }

    public void addLogMessage(JRadiusRequest request, String message) throws RadiusException {
        this.getLogEntry(request).addMessage(message);
    }

    public void commitLogEntries(int result) {
        Iterator<Map.Entry<String, JRadiusLogEntry>> it = this.logEntryMap.entrySet().iterator();
        long now = new Date().getTime();
        long threshold = 180L;
        while (it.hasNext()) {
            Map.Entry<String, JRadiusLogEntry> mapEntry = it.next();
            JRadiusLogEntry entry = mapEntry.getValue();
            if (entry.isFinished() && !entry.isCommitted()) {
                entry.setCode(new Integer(result));
                this.commitLogEntry(entry, result);
                entry.setCommitted(true);
            }
            if (entry.getLastUpdate().getTime() >= now - threshold) continue;
            it.remove();
        }
    }

    public void commitLogEntry(JRadiusLogEntry entry, int result) {
        String mesg = entry.toString();
        if (mesg != null) {
            RadiusLog.info((String)mesg);
        }
    }

    public boolean onPreProcessing(JRadiusRequest request) throws RadiusException {
        block0 : switch (request.getType()) {
            case 2: {
                if (this.getSessionState() != 0) break;
                this.setSessionState(1);
                break;
            }
            case 3: {
                if (!request.isAccountingRequest()) break;
                AccountingRequest accountingRequest = (AccountingRequest)request.getRequestPacket();
                switch (accountingRequest.getAccountingStatusType()) {
                    case -1: {
                        return this.onNoAccountingStatusType(request);
                    }
                    case 1: 
                    case 7: {
                        this.ensureSessionState(request, 2);
                        this.setSessionState(8);
                        break block0;
                    }
                    case 2: 
                    case 8: {
                        this.ensureSessionState(request, 8);
                        this.setSessionState(16);
                        break block0;
                    }
                    case 3: {
                        this.ensureSessionState(request, 8);
                    }
                }
            }
        }
        return false;
    }

    public void onPostProcessing(JRadiusRequest request) throws RadiusException {
        switch (request.getType()) {
            case 2: {
                this.onAuthorization(request);
                break;
            }
            case 8: {
                this.onPostAuthentication(request);
                break;
            }
            case 3: {
                this.onAccounting(request);
            }
        }
    }

    public void onAuthorization(JRadiusRequest request) throws RadiusException {
        if (!this.checkSessionState(11)) {
            this.setSessionState(1);
        }
    }

    public void onPostAuthentication(JRadiusRequest request) throws RadiusException {
        RadiusPacket rep = request.getReplyPacket();
        boolean success = rep instanceof AccessAccept && request.getReturnValue() != 0;
        RadiusLog.debug((String)("Authentication: " + request + " was" + (success ? "" : " NOT") + " sucessful"));
        if (success) {
            Long sessionTimeout = (Long)rep.getAttributeValue(27L);
            if (this.checkSessionState(8)) {
                Long sessionTime;
                if (sessionTimeout != null && (sessionTime = this.getSessionTime()) != null) {
                    sessionTimeout = new Long(sessionTimeout - sessionTime);
                }
            } else {
                this.setSessionState(2);
            }
            this.setIdleTimeout((Long)rep.getAttributeValue(28L));
            this.setInterimInterval((Long)rep.getAttributeValue(85L));
            this.setSessionTimeout(sessionTimeout);
        } else {
            this.setSessionState(4);
        }
    }

    public void stopSession(boolean force) {
        this.setSessionState(16);
    }

    public void initSession(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        String username = (String)req.getAttributeValue(1L);
        String realm = (String)req.getAttributeValue(1045L);
        String stripUsername = null;
        if (username != null) {
            stripUsername = username;
            if (realm == null) {
                String[] s = RadiusSessionSupport.splitUserName((String)username);
                if (s != null && s.length == 2) {
                    stripUsername = s[0];
                    realm = s[1];
                }
            } else {
                stripUsername = (String)req.getAttributeValue(1043L);
                if (stripUsername == null) {
                    stripUsername = username;
                }
            }
        }
        this.setUsername(stripUsername);
        this.setRealm(realm);
        Long zero = new Long(0L);
        this.setSessionTime(zero);
        this.setPacketsIn(zero);
        this.setPacketsOut(zero);
        this.setOctetsIn(zero);
        this.setOctetsOut(zero);
        this.setGigaWordsIn(zero);
        this.setGigaWordsOut(zero);
        this.setServiceType((Long)req.getAttributeValue(6L));
        this.setNasPortType((Long)req.getAttributeValue(61L));
        this.setConnectInfo((String)req.getAttributeValue(77L));
        this.setCallingStationId((String)req.getAttributeValue(31L));
        this.setCalledStationId((String)req.getAttributeValue(30L));
        this.setSessionId((String)req.getAttributeValue(44L));
        this.setNasIdentifier((String)req.getAttributeValue(32L));
        InetAddress inet = (InetAddress)req.getAttributeValue(4L);
        if (inet != null) {
            this.setNasIPAddress(inet.getHostAddress());
        }
        if ((inet = (InetAddress)req.getAttributeValue(8L)) != null) {
            this.setFramedIPAddress(inet.getHostAddress());
        }
        if (this.getNasIdentifier() == null) {
            this.setNasIdentifier(this.getNasIPAddress());
        }
    }

    public void onAccounting(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        Long i = (Long)req.getAttributeValue(45L);
        if (i != null) {
            this.setAcctAuthentic(i);
        }
        if ((i = (Long)req.getAttributeValue(46L)) != null) {
            this.setSessionTime(i);
        }
        if ((i = (Long)req.getAttributeValue(47L)) != null) {
            this.setPacketsIn(i);
        }
        if ((i = (Long)req.getAttributeValue(48L)) != null) {
            this.setPacketsOut(i);
        }
        if ((i = (Long)req.getAttributeValue(49L)) != null) {
            this.setTerminateCause(i);
        }
        Long octsIn = (Long)req.getAttributeValue(42L);
        Long octsOut = (Long)req.getAttributeValue(43L);
        Long gigaIn = (Long)req.getAttributeValue(52L);
        Long gigaOut = (Long)req.getAttributeValue(53L);
        Long cOctsIn = this.getOctetsIn();
        Long cOctsOut = this.getOctetsOut();
        if (octsIn != null && octsOut != null && cOctsIn != null && cOctsOut != null) {
            long newGigawords;
            long currentGigawords;
            if (octsIn < cOctsIn) {
                Long cGigaIn = this.getGigaWordsIn();
                currentGigawords = cGigaIn == null ? 0L : cGigaIn;
                long l = newGigawords = gigaIn == null ? 0L : gigaIn;
                if (newGigawords != currentGigawords + 1L) {
                    this.addLogMessage(request, "Fixing Gigawords-In");
                    gigaIn = new Long(currentGigawords + 1L);
                    req.overwriteAttribute((RadiusAttribute)new Attr_AcctInputGigawords((Serializable)gigaIn));
                }
            }
            if (octsOut < cOctsOut) {
                Long cGigaOut = this.getGigaWordsOut();
                currentGigawords = cGigaOut == null ? 0L : cGigaOut;
                long l = newGigawords = gigaOut == null ? 0L : gigaOut;
                if (newGigawords != currentGigawords + 1L) {
                    this.addLogMessage(request, "Fixing Gigawords-Out");
                    gigaOut = new Long(currentGigawords + 1L);
                    req.overwriteAttribute((RadiusAttribute)new Attr_AcctOutputGigawords((Serializable)gigaOut));
                }
            }
        }
        if (octsIn != null) {
            this.setOctetsIn(octsIn);
        }
        if (octsOut != null) {
            this.setOctetsOut(octsOut);
        }
        if (gigaIn != null) {
            this.setGigaWordsIn(gigaIn);
        }
        if (gigaOut != null) {
            this.setGigaWordsOut(gigaOut);
        }
    }

    protected boolean checkSessionState(int state) {
        return (this.getSessionState() & state) != 0;
    }

    public void ensureSessionState(JRadiusRequest request, int state) throws RadiusException {
        if (!this.checkSessionState(state)) {
            request.getConfigItems().remove(1048L);
            throw new RadiusSecurityException("Received unexpected packet for session: " + this.getSessionKey() + " (" + this.getSessionState() + " != " + state + ")");
        }
    }

    public boolean onNoAccountingStatusType(JRadiusRequest request) throws RadiusException {
        JRadiusLogEntry logEntry = this.getLogEntry(request);
        String error = "Accounting packet without a Acct-Status-Type!";
        RadiusLog.error((String)error);
        logEntry.addMessage(error);
        request.setReturnValue(0);
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Long getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(Long serviceType) {
        this.serviceType = serviceType;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Long getInterimInterval() {
        return this.interimInterval;
    }

    public void setInterimInterval(Long interimInterval) {
        this.interimInterval = interimInterval;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Long getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(Long sessionTime) {
        this.sessionTime = sessionTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getLastInterimTime() {
        return this.lastInterimTime;
    }

    public void setLastInterimTime(Date lastInterimTime) {
        this.lastInterimTime = lastInterimTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public Long getGigaWordsIn() {
        return this.gigaWordsIn;
    }

    public void setGigaWordsIn(Long gigaWordsIn) {
        this.gigaWordsIn = gigaWordsIn;
    }

    public Long getGigaWordsOut() {
        return this.gigaWordsOut;
    }

    public void setGigaWordsOut(Long gigaWordsOut) {
        this.gigaWordsOut = gigaWordsOut;
    }

    public Long getOctetsIn() {
        return this.octetsIn;
    }

    public void setOctetsIn(Long octetsIn) {
        this.octetsIn = octetsIn;
    }

    public Long getOctetsOut() {
        return this.octetsOut;
    }

    public void setOctetsOut(Long octetsOut) {
        this.octetsOut = octetsOut;
    }

    public Long getTotalOctetsIn() {
        if (this.octetsIn == null) {
            return null;
        }
        long l = this.octetsIn;
        if (this.gigaWordsIn != null) {
            l |= this.gigaWordsIn << 32;
        }
        return new Long(l);
    }

    public Long getTotalOctetsOut() {
        if (this.octetsOut == null) {
            return null;
        }
        long l = this.octetsOut;
        if (this.gigaWordsOut != null) {
            l |= this.gigaWordsOut << 32;
        }
        return new Long(l);
    }

    public Long getPacketsIn() {
        return this.packetsIn;
    }

    public void setPacketsIn(Long packetsIn) {
        this.packetsIn = packetsIn;
    }

    public Long getPacketsOut() {
        return this.packetsOut;
    }

    public void setPacketsOut(Long packetsOut) {
        this.packetsOut = packetsOut;
    }

    public Long getTerminateCause() {
        return this.terminateCause;
    }

    public void setTerminateCause(Long terminateCause) {
        this.terminateCause = terminateCause;
    }

    public byte[][] getRadiusClass() {
        return this.radiusClass;
    }

    public void setRadiusClass(byte[][] radiusClass) {
        this.radiusClass = radiusClass;
    }

    public int getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(int sessionState) {
        this.sessionState |= sessionState;
    }

    public String getProxyToRealm() {
        return this.proxyToRealm;
    }

    public void setProxyToRealm(String proxyToRealm) {
        this.proxyToRealm = proxyToRealm;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public String getCalledStationId() {
        return this.calledStationId;
    }

    public void setCalledStationId(String calledStation) {
        this.calledStationId = calledStation;
    }

    public String getCallingStationId() {
        return this.callingStationId;
    }

    public void setCallingStationId(String callingStation) {
        this.callingStationId = callingStation;
    }

    public String getConnectInfo() {
        return this.connectInfo;
    }

    public void setConnectInfo(String connectInfo) {
        this.connectInfo = connectInfo;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public String getFramedIPAddress() {
        return this.framedIPAddress;
    }

    public void setFramedIPAddress(String framedIPAddress) {
        this.framedIPAddress = framedIPAddress;
    }

    public void setClientIPAddress(String clientIP) {
        this.clientIPAddress = clientIP;
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public void setNasIdentifier(String nasID) {
        this.nasIdentifier = nasID;
    }

    public String getNasIPAddress() {
        return this.nasIPAddress;
    }

    public void setNasIPAddress(String nasIP) {
        this.nasIPAddress = nasIP;
    }

    public Long getMaxBandwidthDown() {
        return this.maxBandwidthDown;
    }

    public void setMaxBandwidthDown(Long maxBandwidthDown) {
        this.maxBandwidthDown = maxBandwidthDown;
    }

    public Long getMaxBandwidthUp() {
        return this.maxBandwidthUp;
    }

    public void setMaxBandwidthUp(Long maxBandwidthUp) {
        this.maxBandwidthUp = maxBandwidthUp;
    }

    public Long getMinBandwidthDown() {
        return this.minBandwidthDown;
    }

    public void setMinBandwidthDown(Long minBandwidthDown) {
        this.minBandwidthDown = minBandwidthDown;
    }

    public Long getMinBandwidthUp() {
        return this.minBandwidthUp;
    }

    public void setMinBandwidthUp(Long minBandwidthUp) {
        this.minBandwidthUp = minBandwidthUp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }

    public String getJRadiusKey() {
        return this.jRadiusKey;
    }

    public void setJRadiusKey(String jRadiusKey) {
        this.jRadiusKey = jRadiusKey;
    }

    public JRadiusRequest getLastRadiusRequest() {
        return this.lastRadiusRequest;
    }

    public void setLastRadiusRequest(JRadiusRequest lastRadiusRequest) {
        this.lastRadiusRequest = lastRadiusRequest;
    }

    public Long getMaxOctetsDown() {
        return this.maxOctetsDown;
    }

    public void setMaxOctetsDown(Long maxOctetsDown) {
        this.maxOctetsDown = maxOctetsDown;
    }

    public Long getMaxOctetsUp() {
        return this.maxOctetsUp;
    }

    public void setMaxOctetsUp(Long maxOctetsUp) {
        this.maxOctetsUp = maxOctetsUp;
    }

    public Long getMaxOctetsTotal() {
        return this.maxOctetsTotal;
    }

    public void setMaxOctetsTotal(Long maxOctetsTotal) {
        this.maxOctetsTotal = maxOctetsTotal;
    }

    public String getNasType() {
        return this.nasType;
    }

    public void setNasType(String nasType) {
        this.nasType = nasType;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String toString() {
        return this.getSessionKey();
    }

    public Date getAuthorizeTime() {
        return this.authorizeTime;
    }

    public void setAuthorizeTime(Date authorizeTime) {
        this.authorizeTime = authorizeTime;
    }

    public Long getNasPortType() {
        return this.nasPortType;
    }

    public void setNasPortType(Long nasPortType) {
        this.nasPortType = nasPortType;
    }

    public Long getAcctAuthentic() {
        return this.acctAuthentic;
    }

    public void setAcctAuthentic(Long acctAuthentic) {
        this.acctAuthentic = acctAuthentic;
    }

    public byte[] getRadiusState() {
        return this.radiusState;
    }

    public void setRadiusState(byte[] radiusState) {
        this.radiusState = radiusState;
    }
}

