/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider.asymmetric.ec;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEECPublicKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKKeyFactory;
import org.opennms.shaded.org.bouncycastle.jce.provider.ProviderUtil;
import org.opennms.shaded.org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.opennms.shaded.org.bouncycastle.jce.spec.ECParameterSpec;
import org.opennms.shaded.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.opennms.shaded.org.bouncycastle.jce.spec.ECPublicKeySpec;

public class KeyFactory
extends JDKKeyFactory {
    String algorithm;

    KeyFactory(String string) {
        this.algorithm = string;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            return new JCEECPublicKey((ECPublicKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return new JCEECPrivateKey((ECPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            if (eCPublicKey.getParams() != null) {
                return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec));
        }
        if (clazz.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            if (eCPrivateKey.getParams() != null) {
                return new java.security.spec.ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(eCPrivateKey.getS(), EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec));
        }
        throw new RuntimeException("not implemented yet " + key + " " + clazz);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPrivateKey(this.algorithm, jCEECPrivateKey);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.toString());
            }
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPublicKey(this.algorithm, jCEECPublicKey);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.toString());
            }
        }
        if (keySpec instanceof ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    public static class EC
    extends KeyFactory {
        public EC() {
            super("EC");
        }
    }

    public static class ECDH
    extends KeyFactory {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDHC
    extends KeyFactory {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDSA
    extends KeyFactory {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class ECGOST3410
    extends KeyFactory {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }
}

