/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.security.MessageDigest;
import org.opennms.shaded.org.bouncycastle.crypto.Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.GOST3411Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.MD2Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.MD4Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.MD5Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.RIPEMD320Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA224Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA256Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA384Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA512Digest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.TigerDigest;
import org.opennms.shaded.org.bouncycastle.crypto.digests.WhirlpoolDigest;

public class JDKMessageDigest
extends MessageDigest {
    Digest digest;

    protected JDKMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
    }

    public void engineReset() {
        this.digest.reset();
    }

    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }

    public static class GOST3411
    extends JDKMessageDigest
    implements Cloneable {
        public GOST3411() {
            super(new GOST3411Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            GOST3411 gOST3411 = (GOST3411)super.clone();
            gOST3411.digest = new GOST3411Digest((GOST3411Digest)this.digest);
            return gOST3411;
        }
    }

    public static class MD2
    extends JDKMessageDigest
    implements Cloneable {
        public MD2() {
            super(new MD2Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD2 mD2 = (MD2)super.clone();
            mD2.digest = new MD2Digest((MD2Digest)this.digest);
            return mD2;
        }
    }

    public static class MD4
    extends JDKMessageDigest
    implements Cloneable {
        public MD4() {
            super(new MD4Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD4 mD4 = (MD4)super.clone();
            mD4.digest = new MD4Digest((MD4Digest)this.digest);
            return mD4;
        }
    }

    public static class MD5
    extends JDKMessageDigest
    implements Cloneable {
        public MD5() {
            super(new MD5Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD5 mD5 = (MD5)super.clone();
            mD5.digest = new MD5Digest((MD5Digest)this.digest);
            return mD5;
        }
    }

    public static class RIPEMD128
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD128() {
            super(new RIPEMD128Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            RIPEMD128 rIPEMD128 = (RIPEMD128)super.clone();
            rIPEMD128.digest = new RIPEMD128Digest((RIPEMD128Digest)this.digest);
            return rIPEMD128;
        }
    }

    public static class RIPEMD160
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD160() {
            super(new RIPEMD160Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            RIPEMD160 rIPEMD160 = (RIPEMD160)super.clone();
            rIPEMD160.digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return rIPEMD160;
        }
    }

    public static class RIPEMD256
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD256() {
            super(new RIPEMD256Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            RIPEMD256 rIPEMD256 = (RIPEMD256)super.clone();
            rIPEMD256.digest = new RIPEMD256Digest((RIPEMD256Digest)this.digest);
            return rIPEMD256;
        }
    }

    public static class RIPEMD320
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD320() {
            super(new RIPEMD320Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            RIPEMD320 rIPEMD320 = (RIPEMD320)super.clone();
            rIPEMD320.digest = new RIPEMD320Digest((RIPEMD320Digest)this.digest);
            return rIPEMD320;
        }
    }

    public static class SHA1
    extends JDKMessageDigest
    implements Cloneable {
        public SHA1() {
            super(new SHA1Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA1 sHA1 = (SHA1)super.clone();
            sHA1.digest = new SHA1Digest((SHA1Digest)this.digest);
            return sHA1;
        }
    }

    public static class SHA224
    extends JDKMessageDigest
    implements Cloneable {
        public SHA224() {
            super(new SHA224Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA224 sHA224 = (SHA224)super.clone();
            sHA224.digest = new SHA224Digest((SHA224Digest)this.digest);
            return sHA224;
        }
    }

    public static class SHA256
    extends JDKMessageDigest
    implements Cloneable {
        public SHA256() {
            super(new SHA256Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA256 sHA256 = (SHA256)super.clone();
            sHA256.digest = new SHA256Digest((SHA256Digest)this.digest);
            return sHA256;
        }
    }

    public static class SHA384
    extends JDKMessageDigest
    implements Cloneable {
        public SHA384() {
            super(new SHA384Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA384 sHA384 = (SHA384)super.clone();
            sHA384.digest = new SHA384Digest((SHA384Digest)this.digest);
            return sHA384;
        }
    }

    public static class SHA512
    extends JDKMessageDigest
    implements Cloneable {
        public SHA512() {
            super(new SHA512Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA512 sHA512 = (SHA512)super.clone();
            sHA512.digest = new SHA512Digest((SHA512Digest)this.digest);
            return sHA512;
        }
    }

    public static class Tiger
    extends JDKMessageDigest
    implements Cloneable {
        public Tiger() {
            super(new TigerDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Tiger tiger = (Tiger)super.clone();
            tiger.digest = new TigerDigest((TigerDigest)this.digest);
            return tiger;
        }
    }

    public static class Whirlpool
    extends JDKMessageDigest
    implements Cloneable {
        public Whirlpool() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Whirlpool whirlpool = (Whirlpool)super.clone();
            whirlpool.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return whirlpool;
        }
    }
}

