/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsUtils;

public class Certificate {
    protected X509CertificateStructure[] certs;

    protected static Certificate parse(InputStream inputStream) throws IOException {
        int n;
        Vector<X509CertificateStructure> vector = new Vector<X509CertificateStructure>();
        for (int i = TlsUtils.readUint24(inputStream); i > 0; i -= 3 + n) {
            n = TlsUtils.readUint24(inputStream);
            byte[] byArray = new byte[n];
            TlsUtils.readFully(byArray, inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            vector.addElement(X509CertificateStructure.getInstance(dERObject));
            if (byteArrayInputStream.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        X509CertificateStructure[] x509CertificateStructureArray = new X509CertificateStructure[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            x509CertificateStructureArray[n] = (X509CertificateStructure)vector.elementAt(n);
        }
        return new Certificate(x509CertificateStructureArray);
    }

    private Certificate(X509CertificateStructure[] x509CertificateStructureArray) {
        this.certs = x509CertificateStructureArray;
    }

    public X509CertificateStructure[] getCerts() {
        X509CertificateStructure[] x509CertificateStructureArray = new X509CertificateStructure[this.certs.length];
        System.arraycopy(this.certs, 0, x509CertificateStructureArray, 0, this.certs.length);
        return x509CertificateStructureArray;
    }
}

