/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Set;
import org.opennms.shaded.org.bouncycastle.asn1.BERApplicationSpecific;
import org.opennms.shaded.org.bouncycastle.asn1.BERConstructedOctetString;
import org.opennms.shaded.org.bouncycastle.asn1.BERConstructedSequence;
import org.opennms.shaded.org.bouncycastle.asn1.BERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.BERSet;
import org.opennms.shaded.org.bouncycastle.asn1.BERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERApplicationSpecific;
import org.opennms.shaded.org.bouncycastle.asn1.DERBMPString;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.DERBoolean;
import org.opennms.shaded.org.bouncycastle.asn1.DERConstructedSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERConstructedSet;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERGeneralizedTime;
import org.opennms.shaded.org.bouncycastle.asn1.DERIA5String;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERNull;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;
import org.opennms.shaded.org.bouncycastle.asn1.DERPrintableString;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERSet;
import org.opennms.shaded.org.bouncycastle.asn1.DERT61String;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERUTCTime;
import org.opennms.shaded.org.bouncycastle.asn1.DERUTF8String;
import org.opennms.shaded.org.bouncycastle.asn1.DERUnknownTag;
import org.opennms.shaded.org.bouncycastle.asn1.DERVisibleString;
import org.opennms.shaded.org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static String _dumpAsString(String string, boolean bl, DERObject dERObject) {
        String string2 = System.getProperty("line.separator");
        if (dERObject instanceof ASN1Sequence) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
            String string3 = string + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERConstructedSequence) {
                stringBuffer.append("BER ConstructedSequence");
            } else if (dERObject instanceof DERConstructedSequence) {
                stringBuffer.append("DER ConstructedSequence");
            } else if (dERObject instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (dERObject instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string3);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string3, bl, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string3, bl, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERTaggedObject) {
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = string + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append(']');
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string2);
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string4);
                stringBuffer.append("EMPTY");
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(ASN1Dump._dumpAsString(string4, bl, dERTaggedObject.getObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERConstructedSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string5 = string + TAB;
            stringBuffer.append(string);
            stringBuffer.append("ConstructedSet");
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string5);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string5, bl, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string5, bl, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof BERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = string + TAB;
            stringBuffer.append(string);
            stringBuffer.append("BER Set");
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string6, bl, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string6, bl, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string7 = string + TAB;
            stringBuffer.append(string);
            stringBuffer.append("DER Set");
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string7);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string7, bl, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string7, bl, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERObjectIdentifier) {
            return string + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + string2;
        }
        if (dERObject instanceof DERBoolean) {
            return string + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + string2;
        }
        if (dERObject instanceof DERInteger) {
            return string + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + string2;
        }
        if (dERObject instanceof BERConstructedOctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            if (bl) {
                return string + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] " + ASN1Dump.dumpBinaryDataAsString(string, aSN1OctetString.getOctets()) + string2;
            }
            return string + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] " + string2;
        }
        if (dERObject instanceof DEROctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            if (bl) {
                return string + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] " + ASN1Dump.dumpBinaryDataAsString(string, aSN1OctetString.getOctets()) + string2;
            }
            return string + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] " + string2;
        }
        if (dERObject instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)dERObject;
            if (bl) {
                return string + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] " + ASN1Dump.dumpBinaryDataAsString(string, dERBitString.getBytes()) + string2;
            }
            return string + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] " + string2;
        }
        if (dERObject instanceof DERIA5String) {
            return string + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERUTF8String) {
            return string + "UTF8String(" + ((DERUTF8String)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERPrintableString) {
            return string + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERVisibleString) {
            return string + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERBMPString) {
            return string + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERT61String) {
            return string + "T61String(" + ((DERT61String)dERObject).getString() + ") " + string2;
        }
        if (dERObject instanceof DERUTCTime) {
            return string + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + string2;
        }
        if (dERObject instanceof DERGeneralizedTime) {
            return string + "GeneralizedTime(" + ((DERGeneralizedTime)dERObject).getTime() + ") " + string2;
        }
        if (dERObject instanceof DERUnknownTag) {
            return string + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + string2;
        }
        if (dERObject instanceof BERApplicationSpecific) {
            return ASN1Dump.outputApplicationSpecific("BER", string, bl, dERObject, string2);
        }
        if (dERObject instanceof DERApplicationSpecific) {
            return ASN1Dump.outputApplicationSpecific("DER", string, bl, dERObject, string2);
        }
        return string + dERObject.toString() + string2;
    }

    private static String outputApplicationSpecific(String string, String string2, boolean bl, DERObject dERObject, String string3) {
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        StringBuffer stringBuffer = new StringBuffer();
        if (dERApplicationSpecific.isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(dERApplicationSpecific.getObject(16));
                stringBuffer.append(string2 + string + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "]" + string3);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string2 + TAB, bl, (DERObject)enumeration.nextElement()));
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string2 + string + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "] (" + new String(Hex.encode(dERApplicationSpecific.getContents())) + ")" + string3;
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        if (object instanceof DERObject) {
            return ASN1Dump._dumpAsString("", bl, (DERObject)object);
        }
        if (object instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", bl, ((DEREncodable)object).getDERObject());
        }
        return "unknown object type " + object.toString();
    }

    private static String dumpBinaryDataAsString(String string, byte[] byArray) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        string = string + TAB;
        stringBuffer.append(string2);
        for (int i = 0; i < byArray.length; i += 32) {
            if (byArray.length - i > 32) {
                stringBuffer.append(string);
                stringBuffer.append(new String(Hex.encode(byArray, i, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, 32));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(new String(Hex.encode(byArray, i, byArray.length - i)));
            for (int j = byArray.length - i; j != 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, byArray.length - i));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }
}

