/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.opennms.shaded.org.bouncycastle.crypto.BufferedBlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.engines.AESEngine;
import org.opennms.shaded.org.bouncycastle.crypto.engines.AESFastEngine;
import org.opennms.shaded.org.bouncycastle.crypto.engines.AESWrapEngine;
import org.opennms.shaded.org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.opennms.shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEBlockCipher;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEKeyGenerator;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKAlgorithmParameters;
import org.opennms.shaded.org.bouncycastle.jce.provider.WrapCipherSpi;

public final class AES {
    private AES() {
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("AES", "BC");
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "AES IV";
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class CFB
    extends JCEBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new AESFastEngine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            this(192);
        }

        public KeyGen(int n) {
            super("AES", n, new CipherKeyGenerator());
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class OFB
    extends JCEBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class RFC3211Wrap
    extends WrapCipherSpi {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new AESEngine()), 16);
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new AESWrapEngine());
        }
    }
}

