/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAValidationParameters;

public class DSAParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int n, int n2, SecureRandom secureRandom) {
        this.size = n;
        this.certainty = n2;
        this.random = secureRandom;
    }

    private void add(byte[] byArray, byte[] byArray2, int n) {
        int n2 = (byArray2[byArray2.length - 1] & 0xFF) + n;
        byArray[byArray2.length - 1] = (byte)n2;
        n2 >>>= 8;
        for (int i = byArray2.length - 2; i >= 0; --i) {
            byArray[i] = (byte)(n2 += byArray2[i] & 0xFF);
            n2 >>>= 8;
        }
    }

    public DSAParameters generateParameters() {
        BigInteger bigInteger;
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[20];
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n = (this.size - 1) / 160;
        byte[] byArray5 = new byte[this.size / 8];
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        int n2 = 0;
        boolean bl = false;
        block0: while (!bl) {
            int n3;
            do {
                this.random.nextBytes(byArray);
                sHA1Digest.update(byArray, 0, byArray.length);
                sHA1Digest.doFinal(byArray2, 0);
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                this.add(byArray3, byArray, 1);
                sHA1Digest.update(byArray3, 0, byArray3.length);
                sHA1Digest.doFinal(byArray3, 0);
                for (n3 = 0; n3 != byArray4.length; ++n3) {
                    byArray4[n3] = (byte)(byArray2[n3] ^ byArray3[n3]);
                }
                byArray4[0] = (byte)(byArray4[0] | 0xFFFFFF80);
                byArray4[19] = (byte)(byArray4[19] | 1);
            } while (!(bigInteger2 = new BigInteger(1, byArray4)).isProbablePrime(this.certainty));
            n2 = 0;
            n3 = 2;
            while (n2 < 4096) {
                for (int i = 0; i < n; ++i) {
                    this.add(byArray2, byArray, n3 + i);
                    sHA1Digest.update(byArray2, 0, byArray2.length);
                    sHA1Digest.doFinal(byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray5, byArray5.length - (i + 1) * byArray2.length, byArray2.length);
                }
                this.add(byArray2, byArray, n3 + n);
                sHA1Digest.update(byArray2, 0, byArray2.length);
                sHA1Digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, byArray2.length - (byArray5.length - n * byArray2.length), byArray5, 0, byArray5.length - n * byArray2.length);
                byArray5[0] = (byte)(byArray5[0] | 0xFFFFFF80);
                bigInteger = new BigInteger(1, byArray5);
                BigInteger bigInteger5 = bigInteger.mod(bigInteger2.multiply(TWO));
                bigInteger3 = bigInteger.subtract(bigInteger5.subtract(ONE));
                if (bigInteger3.testBit(this.size - 1) && bigInteger3.isProbablePrime(this.certainty)) {
                    bl = true;
                    continue block0;
                }
                ++n2;
                n3 += n + 1;
            }
        }
        BigInteger bigInteger6 = bigInteger3.subtract(ONE).divide(bigInteger2);
        while ((bigInteger = new BigInteger(this.size, this.random)).compareTo(ONE) <= 0 || bigInteger.compareTo(bigInteger3.subtract(ONE)) >= 0 || (bigInteger4 = bigInteger.modPow(bigInteger6, bigInteger3)).compareTo(ONE) <= 0) {
        }
        return new DSAParameters(bigInteger3, bigInteger2, bigInteger4, new DSAValidationParameters(byArray, n2));
    }
}

