/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.x509.qualified;

import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;

public class QCStatement
extends ASN1Encodable
implements ETSIQCObjectIdentifiers,
RFC3739QCObjectIdentifiers {
    DERObjectIdentifier qcStatementId;
    ASN1Encodable qcStatementInfo;

    public static QCStatement getInstance(Object object) {
        if (object == null || object instanceof QCStatement) {
            return (QCStatement)object;
        }
        if (object instanceof ASN1Sequence) {
            return new QCStatement(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public QCStatement(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.qcStatementId = DERObjectIdentifier.getInstance(enumeration.nextElement());
        if (enumeration.hasMoreElements()) {
            this.qcStatementInfo = (ASN1Encodable)enumeration.nextElement();
        }
    }

    public QCStatement(DERObjectIdentifier dERObjectIdentifier) {
        this.qcStatementId = dERObjectIdentifier;
        this.qcStatementInfo = null;
    }

    public QCStatement(DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.qcStatementId = dERObjectIdentifier;
        this.qcStatementInfo = aSN1Encodable;
    }

    public DERObjectIdentifier getStatementId() {
        return this.qcStatementId;
    }

    public ASN1Encodable getStatementInfo() {
        return this.qcStatementInfo;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.qcStatementId);
        if (this.qcStatementInfo != null) {
            aSN1EncodableVector.add(this.qcStatementInfo);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

