/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.cmp;

import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.cmp.CMPCertificate;
import org.opennms.shaded.org.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Encodable {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), true);
        }
        this.response = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public static CertRepMessage getInstance(Object object) {
        if (object instanceof CertRepMessage) {
            return (CertRepMessage)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertRepMessage((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caPubs.size()];
        for (int i = 0; i != cMPCertificateArray.length; ++i) {
            cMPCertificateArray[i] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i));
        }
        return cMPCertificateArray;
    }

    public CertResponse[] getResponse() {
        CertResponse[] certResponseArray = new CertResponse[this.response.size()];
        for (int i = 0; i != certResponseArray.length; ++i) {
            certResponseArray[i] = CertResponse.getInstance(this.response.getObjectAt(i));
        }
        return certResponseArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.caPubs != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        aSN1EncodableVector.add(this.response);
        return new DERSequence(aSN1EncodableVector);
    }
}

