/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1;

import java.io.IOException;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Object;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DEROutputStream;
import org.opennms.shaded.org.bouncycastle.asn1.DERString;

public class DERT61String
extends ASN1Object
implements DERString {
    String string;

    public static DERT61String getInstance(Object object) {
        if (object == null || object instanceof DERT61String) {
            return (DERT61String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERT61String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERT61String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERT61String.getInstance(aSN1TaggedObject.getObject());
    }

    public DERT61String(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERT61String(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(20, this.getOctets());
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERT61String)) {
            return false;
        }
        return this.getString().equals(((DERT61String)dERObject).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

