/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Object;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.opennms.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.DHParameter;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.opennms.shaded.org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.opennms.shaded.org.bouncycastle.asn1.sec.SECNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.x509.DSAParameter;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X962NamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X962Parameters;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ElGamalParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure rSAPrivateKeyStructure = new RSAPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(rSAPrivateKeyStructure.getModulus(), rSAPrivateKeyStructure.getPublicExponent(), rSAPrivateKeyStructure.getPrivateExponent(), rSAPrivateKeyStructure.getPrime1(), rSAPrivateKeyStructure.getPrime2(), rSAPrivateKeyStructure.getExponent1(), rSAPrivateKeyStructure.getExponent2(), rSAPrivateKeyStructure.getCoefficient());
        }
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter dHParameter = new DHParameter((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            BigInteger bigInteger = dHParameter.getL();
            int n = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n);
            return new DHPrivateKeyParameters(dERInteger.getValue(), dHParameters);
        }
        if (algorithmIdentifier.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(dERInteger.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DERInteger dERInteger = (DERInteger)privateKeyInfo.getPrivateKey();
            DEREncodable dEREncodable = privateKeyInfo.getAlgorithmId().getParameters();
            DSAParameters dSAParameters = null;
            if (dEREncodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance(dEREncodable.getDERObject());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPrivateKeyParameters(dERInteger.getValue(), dSAParameters);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)privateKeyInfo.getAlgorithmId().getParameters());
            ECDomainParameters eCDomainParameters = null;
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                X9ECParameters x9ECParameters = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                if (x9ECParameters == null && (x9ECParameters = SECNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable)) == null && (x9ECParameters = NISTNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable)) == null) {
                    x9ECParameters = TeleTrusTNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                }
                eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            }
            aSN1Encodable = new ECPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(((ECPrivateKeyStructure)aSN1Encodable).getKey(), eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

