/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.IOException;
import java.io.InputStream;
import net.jradius.tls.Certificate;
import net.jradius.tls.CertificateVerifyer;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsKeyExchange;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.tls.TlsUtils;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.x509.KeyUsage;
import org.opennms.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Extension;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Extensions;
import org.opennms.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import org.opennms.shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.opennms.shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;

class TlsRSAKeyExchange
implements TlsKeyExchange {
    private TlsProtocolHandler handler;
    private CertificateVerifyer verifyer;
    private AsymmetricKeyParameter serverPublicKey = null;
    private RSAKeyParameters rsaServerPublicKey = null;
    private byte[] premasterSecret;

    TlsRSAKeyExchange(TlsProtocolHandler handler, CertificateVerifyer verifyer) {
        this.handler = handler;
        this.verifyer = verifyer;
    }

    public void skipServerCertificate() throws IOException {
        this.handler.failWithError((short)2, (short)10);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            this.handler.failWithError((short)2, (short)43);
        }
        if (this.serverPublicKey.isPrivate()) {
            this.handler.failWithError((short)2, (short)80);
        }
        if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
            this.handler.failWithError((short)2, (short)46);
        }
        this.validateKeyUsage(x509Cert, 32);
        this.rsaServerPublicKey = this.validateRSAPublicKey((RSAKeyParameters)this.serverPublicKey);
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            this.handler.failWithError((short)2, (short)90);
        }
    }

    public void skipServerKeyExchange() throws IOException {
    }

    public void processServerKeyExchange(InputStream is, SecurityParameters securityParameters) throws IOException {
        this.handler.failWithError((short)2, (short)10);
    }

    public byte[] generateClientKeyExchange() throws IOException {
        this.premasterSecret = new byte[48];
        this.handler.getRandom().nextBytes(this.premasterSecret);
        TlsUtils.writeVersion(this.premasterSecret, 0);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, new ParametersWithRandom(this.rsaServerPublicKey, this.handler.getRandom()));
        try {
            return encoding.processBlock(this.premasterSecret, 0, this.premasterSecret.length);
        }
        catch (InvalidCipherTextException e) {
            this.handler.failWithError((short)2, (short)80);
            return null;
        }
    }

    public byte[] generatePremasterSecret() throws IOException {
        byte[] tmp = this.premasterSecret;
        this.premasterSecret = null;
        return tmp;
    }

    private void validateKeyUsage(X509CertificateStructure c, int keyUsageBits) throws IOException {
        DERBitString ku;
        int bits;
        X509Extension ext;
        X509Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(X509Extensions.KeyUsage)) != null && ((bits = (ku = KeyUsage.getInstance(ext)).getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            this.handler.failWithError((short)2, (short)46);
        }
    }

    private RSAKeyParameters validateRSAPublicKey(RSAKeyParameters key) throws IOException {
        if (!key.getExponent().isProbablePrime(2)) {
            this.handler.failWithError((short)2, (short)47);
        }
        return key;
    }
}

