/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.crmf;

import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedValue
extends ASN1Encodable {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private DERBitString encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private ASN1OctetString valueHint;
    private DERBitString encValue;

    private EncryptedValue(ASN1Sequence aSN1Sequence) {
        int n = 0;
        while (aSN1Sequence.getObjectAt(n) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.intendedAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 1: {
                    this.symmAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 2: {
                    this.encSymmKey = DERBitString.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 3: {
                    this.keyAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 4: {
                    this.valueHint = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                }
            }
            ++n;
        }
        this.encValue = DERBitString.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public static EncryptedValue getInstance(Object object) {
        if (object instanceof EncryptedValue) {
            return (EncryptedValue)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncryptedValue((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.addOptional(aSN1EncodableVector, 0, this.intendedAlg);
        this.addOptional(aSN1EncodableVector, 1, this.symmAlg);
        this.addOptional(aSN1EncodableVector, 2, this.encSymmKey);
        this.addOptional(aSN1EncodableVector, 3, this.keyAlg);
        this.addOptional(aSN1EncodableVector, 4, this.valueHint);
        aSN1EncodableVector.add(this.encValue);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, n, aSN1Encodable));
        }
    }
}

