/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner
implements Closeable {
    final File directory;
    final FilenameFilter filter;
    Map<File, Long> lastChecksums = new HashMap<File, Long>();
    Map<File, Long> storedChecksums = new HashMap<File, Long>();

    public Scanner(File directory) {
        this(directory, null);
    }

    public Scanner(File directory, final String filterString) {
        this.directory = Scanner.canon(directory);
        this.filter = filterString != null && filterString.length() > 0 ? new FilenameFilter(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile(filterString);
            }

            public boolean accept(File dir, String name) {
                return this.pattern.matcher(name).matches();
            }
        } : null;
    }

    public void initialize(Map<File, Long> checksums) {
        this.storedChecksums.putAll(checksums);
    }

    public Set<File> scan(boolean reportImmediately) {
        File[] list = this.directory.listFiles(this.filter);
        if (list == null) {
            return null;
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>(this.storedChecksums.keySet());
        for (File file : list) {
            long lastChecksum = this.lastChecksums.get(file) != null ? this.lastChecksums.get(file) : 0L;
            long storedChecksum = this.storedChecksums.get(file) != null ? this.storedChecksums.get(file) : 0L;
            long newChecksum = Scanner.checksum(file);
            this.lastChecksums.put(file, newChecksum);
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this.storedChecksums.put(file, newChecksum);
                files.add(file);
            }
            removed.remove(file);
        }
        for (File file : removed) {
            files.addAll(removed);
            this.lastChecksums.remove(file);
            this.storedChecksums.remove(file);
        }
        return files;
    }

    @Override
    public void close() throws IOException {
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public long getChecksum(File file) {
        Long c = this.storedChecksums.get(file);
        return c != null ? c : 0L;
    }

    public void updateChecksum(File file) {
        if (file != null && this.storedChecksums.containsKey(file)) {
            long newChecksum = Scanner.checksum(file);
            this.storedChecksums.put(file, newChecksum);
        }
    }

    static long checksum(File file) {
        CRC32 crc = new CRC32();
        Scanner.checksum(file, crc);
        return crc.getValue();
    }

    private static void checksum(File file, CRC32 crc) {
        File[] children;
        crc.update(file.getName().getBytes());
        if (file.isFile()) {
            Scanner.checksum(file.lastModified(), crc);
            Scanner.checksum(file.length(), crc);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File aChildren : children) {
                Scanner.checksum(aChildren, crc);
            }
        }
    }

    private static void checksum(long l, CRC32 crc) {
        for (int i = 0; i < 8; ++i) {
            crc.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }
}

