/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.osgi.resource.CapReq;
import aQute.bnd.osgi.resource.Filters;
import aQute.libg.filters.AndFilter;
import aQute.libg.filters.Filter;
import aQute.libg.filters.LiteralFilter;
import aQute.libg.filters.SimpleFilter;
import java.util.HashMap;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapReqBuilder {
    private final String namespace;
    private Resource resource;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> directives = new HashMap<String, String>();

    public CapReqBuilder(String namespace) {
        this.namespace = namespace;
    }

    public static CapReqBuilder clone(Capability capability) {
        CapReqBuilder builder = new CapReqBuilder(capability.getNamespace());
        builder.addAttributes(capability.getAttributes());
        builder.addDirectives(capability.getDirectives());
        return builder;
    }

    public static CapReqBuilder clone(Requirement requirement) {
        CapReqBuilder builder = new CapReqBuilder(requirement.getNamespace());
        builder.addAttributes(requirement.getAttributes());
        builder.addDirectives(requirement.getDirectives());
        return builder;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CapReqBuilder setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public CapReqBuilder addAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        }
        return this;
    }

    public CapReqBuilder addAttributes(Map<? extends String, ? extends Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public CapReqBuilder addDirective(String name, String value) {
        if (value != null) {
            this.directives.put(name, value);
        }
        return this;
    }

    public CapReqBuilder addDirectives(Map<? extends String, ? extends String> directives) {
        this.directives.putAll(directives);
        return this;
    }

    public Capability buildCapability() {
        if (this.resource == null) {
            throw new IllegalStateException("Cannot build Capability with null Resource.");
        }
        return new CapReq(CapReq.MODE.Capability, this.namespace, this.resource, this.directives, this.attributes);
    }

    public Requirement buildRequirement() {
        if (this.resource == null) {
            throw new IllegalStateException("Cannot build Requirement with null Resource.");
        }
        return new CapReq(CapReq.MODE.Requirement, this.namespace, this.resource, this.directives, this.attributes);
    }

    public Requirement buildSyntheticRequirement() {
        return new CapReq(CapReq.MODE.Requirement, this.namespace, null, this.directives, this.attributes);
    }

    public static final CapReqBuilder createPackageRequirement(String pkgName, String range) {
        SimpleFilter pkgNameFilter = new SimpleFilter("osgi.wiring.package", pkgName);
        Filter filter = range != null ? new AndFilter().addChild(pkgNameFilter).addChild(new LiteralFilter(Filters.fromVersionRange(range))) : pkgNameFilter;
        return new CapReqBuilder("osgi.wiring.package").addDirective("filter", filter.toString());
    }
}

