/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableUtils {
    public static CloseFuture closed() {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        future.setClosed();
        return future;
    }

    public static Closeable parallel(Collection<? extends Closeable> closeables) {
        return CloseableUtils.parallel(null, closeables);
    }

    public static Closeable parallel(Object lock, Collection<? extends Closeable> closeables) {
        return CloseableUtils.parallel(lock, closeables.toArray(new Closeable[closeables.size()]));
    }

    public static Closeable parallel(Closeable ... closeables) {
        return CloseableUtils.parallel(null, closeables);
    }

    public static Closeable parallel(final Object lock, final Closeable ... closeables) {
        int nbNonNulls = 0;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            ++nbNonNulls;
        }
        if (nbNonNulls == 0) {
            return new Closeable(){
                final CloseFuture future;
                {
                    this.future = new DefaultCloseFuture(lock);
                }

                public boolean isClosed() {
                    return this.future.isClosed();
                }

                public boolean isClosing() {
                    return this.isClosed();
                }

                public CloseFuture close(boolean immediately) {
                    this.future.setClosed();
                    return this.future;
                }
            };
        }
        if (nbNonNulls == 1) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                return closeable;
            }
            throw new IllegalStateException();
        }
        return new Closeable(){
            final CloseFuture future;
            final AtomicBoolean closing;
            {
                this.future = new DefaultCloseFuture(lock);
                this.closing = new AtomicBoolean();
            }

            public boolean isClosed() {
                return this.future.isClosed();
            }

            public boolean isClosing() {
                return this.closing.get();
            }

            public CloseFuture close(boolean immediately) {
                final AtomicInteger count = new AtomicInteger(closeables.length);
                if (this.closing.compareAndSet(false, true)) {
                    SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                        @Override
                        public void operationComplete(CloseFuture f) {
                            if (count.decrementAndGet() == 0) {
                                future.setClosed();
                            }
                        }
                    };
                    for (Closeable c : closeables) {
                        if (c != null) {
                            c.close(immediately).addListener(listener);
                            continue;
                        }
                        listener.operationComplete(null);
                    }
                }
                return this.future;
            }
        };
    }

    public static Closeable sequential(Collection<? extends Closeable> closeables) {
        return CloseableUtils.sequential(null, closeables);
    }

    public static Closeable sequential(Object lock, Collection<? extends Closeable> closeables) {
        return CloseableUtils.sequential(lock, closeables.toArray(new Closeable[closeables.size()]));
    }

    public static Closeable sequential(Closeable ... closeables) {
        return CloseableUtils.sequential(null, closeables);
    }

    public static Closeable sequential(final Object lock, final Closeable ... closeables) {
        int nbNonNulls = 0;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            ++nbNonNulls;
        }
        if (nbNonNulls == 0) {
            return new Closeable(){
                final CloseFuture future;
                {
                    this.future = new DefaultCloseFuture(lock);
                }

                public boolean isClosed() {
                    return this.future.isClosed();
                }

                public boolean isClosing() {
                    return this.isClosed();
                }

                public CloseFuture close(boolean immediately) {
                    this.future.setClosed();
                    return this.future;
                }
            };
        }
        if (nbNonNulls == 1) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                return closeable;
            }
            throw new IllegalStateException();
        }
        return new Closeable(){
            final DefaultCloseFuture future;
            final AtomicBoolean closing;
            {
                this.future = new DefaultCloseFuture(lock);
                this.closing = new AtomicBoolean();
            }

            public boolean isClosed() {
                return this.future.isClosed();
            }

            public boolean isClosing() {
                return this.closing.get();
            }

            public CloseFuture close(final boolean immediately) {
                if (this.closing.compareAndSet(false, true)) {
                    final Iterator<Closeable> iterator = Arrays.asList(closeables).iterator();
                    SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                        @Override
                        public void operationComplete(CloseFuture previousFuture) {
                            while (iterator.hasNext()) {
                                Closeable c = (Closeable)iterator.next();
                                if (c == null) continue;
                                CloseFuture nextFuture = c.close(immediately);
                                nextFuture.addListener(this);
                                return;
                            }
                            if (!iterator.hasNext()) {
                                future.setClosed();
                            }
                        }
                    };
                    listener.operationComplete(null);
                }
                return this.future;
            }
        };
    }

    public static <T extends SshFuture> CloseFuture parallel(SshFuture<T> ... futures) {
        return CloseableUtils.parallel(null, futures);
    }

    public static <T extends SshFuture> CloseFuture parallel(Object lock, SshFuture<T> ... futures) {
        final DefaultCloseFuture future = new DefaultCloseFuture(lock);
        if (futures.length > 0) {
            final AtomicInteger count = new AtomicInteger(futures.length);
            SshFutureListener listener = new SshFutureListener<T>(){

                @Override
                public void operationComplete(T f) {
                    if (count.decrementAndGet() == 0) {
                        future.setClosed();
                    }
                }
            };
            for (SshFuture<T> f : futures) {
                if (f != null) {
                    f.addListener(listener);
                    continue;
                }
                listener.operationComplete(null);
            }
        } else {
            future.setClosed();
        }
        return future;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Logger logger, Object lock) {
        return new Builder();
    }

    private CloseableUtils() {
    }

    public static abstract class AbstractInnerCloseable
    extends AbstractCloseable {
        protected abstract Closeable getInnerCloseable();

        protected CloseFuture doCloseGracefully() {
            return this.getInnerCloseable().close(false);
        }

        protected void doCloseImmediately() {
            this.getInnerCloseable().close(true).addListener(new SshFutureListener<CloseFuture>(){

                @Override
                public void operationComplete(CloseFuture future) {
                    AbstractInnerCloseable.super.doCloseImmediately();
                }
            });
        }
    }

    public static abstract class AbstractCloseable
    implements Closeable {
        protected static final int OPENED = 0;
        protected static final int GRACEFUL = 1;
        protected static final int IMMEDIATE = 2;
        protected static final int CLOSED = 3;
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        protected final Object lock;
        protected final AtomicInteger state = new AtomicInteger(0);
        protected final CloseFuture closeFuture;

        protected AbstractCloseable() {
            this(new Object());
        }

        protected AbstractCloseable(Object lock) {
            this.lock = lock;
            this.closeFuture = new DefaultCloseFuture(lock);
        }

        public CloseFuture close(boolean immediately) {
            if (immediately) {
                if (this.state.compareAndSet(0, 2) || this.state.compareAndSet(1, 2)) {
                    this.log.debug("Closing {} immediately", (Object)this);
                    this.preClose();
                    this.doCloseImmediately();
                    this.log.debug("{} closed", (Object)this);
                } else {
                    this.log.debug("{} is already {}", (Object)this, (Object)(this.state.get() == 3 ? "closed" : "closing"));
                }
            } else if (this.state.compareAndSet(0, 1)) {
                this.log.debug("Closing {} gracefully", (Object)this);
                this.preClose();
                CloseFuture grace = this.doCloseGracefully();
                if (grace != null) {
                    grace.addListener(new SshFutureListener<CloseFuture>(){

                        @Override
                        public void operationComplete(CloseFuture future) {
                            if (AbstractCloseable.this.state.compareAndSet(1, 2)) {
                                AbstractCloseable.this.doCloseImmediately();
                                AbstractCloseable.this.log.debug("{} closed", (Object)AbstractCloseable.this);
                            }
                        }
                    });
                } else if (this.state.compareAndSet(1, 2)) {
                    this.doCloseImmediately();
                    this.log.debug("{} closed", (Object)this);
                }
            } else {
                this.log.debug("{} is already {}", (Object)this, (Object)(this.state.get() == 3 ? "closed" : "closing"));
            }
            return this.closeFuture;
        }

        public boolean isClosed() {
            return this.state.get() == 3;
        }

        public boolean isClosing() {
            return this.state.get() != 0;
        }

        protected void preClose() {
        }

        protected CloseFuture doCloseGracefully() {
            return null;
        }

        protected void doCloseImmediately() {
            this.closeFuture.setClosed();
            this.state.set(3);
        }

        protected Builder builder() {
            return new Builder(this.lock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Object lock;
        private Closeable closeable = null;

        public Builder() {
            this(null);
        }

        public Builder(Object lock) {
            this.lock = lock;
        }

        public <T extends SshFuture> Builder when(final SshFuture<T> ... futures) {
            return this.close(new Closeable(){
                private volatile boolean closing;
                private volatile boolean closed;

                public CloseFuture close(boolean immediately) {
                    this.closing = true;
                    if (immediately) {
                        for (SshFuture future : futures) {
                            if (!(future instanceof DefaultSshFuture)) continue;
                            ((DefaultSshFuture)future).setValue(new SshException("Closed"));
                        }
                        this.closed = true;
                        return CloseableUtils.closed();
                    }
                    return CloseableUtils.parallel(Builder.this.lock, futures).addListener(new SshFutureListener<CloseFuture>(){

                        @Override
                        public void operationComplete(CloseFuture future) {
                            closed = true;
                        }
                    });
                }

                public boolean isClosed() {
                    return this.closed;
                }

                public boolean isClosing() {
                    return this.closing || this.closed;
                }
            });
        }

        public <T extends SshFuture> Builder when(Collection<? extends SshFuture<T>> futures) {
            return this.when(futures.toArray(new SshFuture[futures.size()]));
        }

        public Builder sequential(Closeable ... closeables) {
            return this.close(CloseableUtils.sequential(this.lock, closeables));
        }

        public Builder sequential(Collection<Closeable> closeables) {
            return this.close(CloseableUtils.sequential(this.lock, closeables));
        }

        public Builder parallel(Closeable ... closeables) {
            return this.close(CloseableUtils.parallel(this.lock, closeables));
        }

        public Builder parallel(Collection<? extends Closeable> closeables) {
            return this.close(CloseableUtils.parallel(this.lock, closeables));
        }

        public Builder close(Closeable c) {
            this.closeable = this.closeable == null ? c : CloseableUtils.sequential(this.lock, this.closeable, c);
            return this;
        }

        public Closeable build() {
            if (this.closeable == null) {
                this.closeable = new Closeable(){
                    private volatile boolean closed;

                    public CloseFuture close(boolean immediately) {
                        this.closed = true;
                        return CloseableUtils.closed();
                    }

                    public boolean isClosed() {
                        return this.closed;
                    }

                    public boolean isClosing() {
                        return this.closed;
                    }
                };
            }
            return this.closeable;
        }
    }
}

