/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.ContentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureImpl
extends ContentImpl
implements Feature {
    public static String SPLIT_FOR_NAME_AND_VERSION = "_split_for_name_and_version_";
    public static String DEFAULT_VERSION = "0.0.0";
    public static String VERSION_PREFIX = "version=";
    private String id;
    private String name;
    private String description;
    private String details;
    private String version;
    private String resolver;
    private String install = "auto";
    private List<Conditional> conditionals = new ArrayList<Conditional>();

    public FeatureImpl() {
    }

    public FeatureImpl(String name) {
        this(name, DEFAULT_VERSION);
    }

    public FeatureImpl(String name, String version) {
        this.name = name;
        this.version = version;
        this.id = name + "-" + version;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    @Override
    public String getInstall() {
        return this.install;
    }

    public void setInstall(String install) {
        this.install = install;
    }

    @Override
    public List<Conditional> getConditional() {
        return this.conditionals;
    }

    public void addConditional(Conditional conditional) {
        this.conditionals.add(conditional);
    }

    public String toString() {
        String ret = this.getName() + SPLIT_FOR_NAME_AND_VERSION + this.getVersion();
        return ret;
    }

    public static Feature valueOf(String str) {
        if (str.indexOf(SPLIT_FOR_NAME_AND_VERSION) >= 0) {
            String strName = str.substring(0, str.indexOf(SPLIT_FOR_NAME_AND_VERSION));
            String strVersion = str.substring(str.indexOf(SPLIT_FOR_NAME_AND_VERSION) + SPLIT_FOR_NAME_AND_VERSION.length(), str.length());
            return new FeatureImpl(strName, strVersion);
        }
        return new FeatureImpl(str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImpl feature = (FeatureImpl)o;
        if (!this.name.equals(feature.name)) {
            return false;
        }
        return this.version.equals(feature.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

