/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.help;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.Terminal;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.HelpProvider;
import org.apache.karaf.shell.console.NameScoping;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandListHelpProvider
implements HelpProvider {
    public static final String COMMANDS = ".commands";

    @Override
    public String getHelp(CommandSession session, String path) {
        if (path.indexOf(124) > 0) {
            if (path.startsWith("command-list|")) {
                path = path.substring("command-list|".length());
            } else {
                return null;
            }
        }
        SortedMap<String, String> commands = this.getCommandDescriptions(session, path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printMethodList(session, new PrintStream(baos), commands);
        return baos.toString();
    }

    private SortedMap<String, String> getCommandDescriptions(CommandSession session, String command) {
        Set names = (Set)session.get(COMMANDS);
        TreeMap<String, String> commands = new TreeMap<String, String>();
        for (String name : names) {
            if (command != null && !name.startsWith(command)) continue;
            String description = null;
            Function function = (Function)session.get(name);
            if (!((function = this.unProxy(function)) instanceof AbstractCommand)) continue;
            try {
                Method mth = AbstractCommand.class.getDeclaredMethod("createNewAction", new Class[0]);
                mth.setAccessible(true);
                Action action = (Action)mth.invoke((Object)function, new Object[0]);
                Class<?> clazz = action.getClass();
                Command ann = clazz.getAnnotation(Command.class);
                description = ann.description();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (name.startsWith("*:")) {
                name = name.substring(2);
            }
            commands.put(name, description);
        }
        return commands;
    }

    protected void printMethodList(CommandSession session, PrintStream out, SortedMap<String, String> commands) {
        String prefix2;
        Terminal term = (Terminal)session.get(".jline.terminal");
        out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("COMMANDS").a(Ansi.Attribute.RESET));
        int max = 0;
        for (Map.Entry<String, String> entry : commands.entrySet()) {
            String key = NameScoping.getCommandNameWithoutGlobalPrefix(session, entry.getKey());
            max = Math.max(max, key.length());
        }
        int margin = 4;
        String prefix1 = "        ";
        if (term != null && term.getWidth() - max - prefix1.length() - margin > 50) {
            prefix2 = prefix1;
            for (int i = 0; i < max + margin; ++i) {
                prefix2 = prefix2 + " ";
            }
            for (Map.Entry<String, String> entry : commands.entrySet()) {
                out.print(prefix1);
                String key = NameScoping.getCommandNameWithoutGlobalPrefix(session, entry.getKey());
                out.print(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(key).a(Ansi.Attribute.RESET));
                for (int i = 0; i < max - key.length() + margin; ++i) {
                    out.print(' ');
                }
                if (entry.getValue() == null) continue;
                DefaultActionPreparator.printFormatted(prefix2, entry.getValue(), term.getWidth(), out, false);
            }
        } else {
            prefix2 = prefix1 + prefix1;
            for (Map.Entry<String, String> entry : commands.entrySet()) {
                out.print(prefix1);
                String key = NameScoping.getCommandNameWithoutGlobalPrefix(session, entry.getKey());
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(key).a(Ansi.Attribute.RESET));
                if (entry.getValue() == null) continue;
                DefaultActionPreparator.printFormatted(prefix2, entry.getValue(), term != null ? term.getWidth() : 80, out);
            }
        }
        out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function unProxy(Function function) {
        block6: {
            try {
                if (!function.getClass().getName().contains("CommandProxy")) break block6;
                Field contextField = function.getClass().getDeclaredField("context");
                Field referenceField = function.getClass().getDeclaredField("reference");
                contextField.setAccessible(true);
                referenceField.setAccessible(true);
                BundleContext context = (BundleContext)contextField.get(function);
                ServiceReference reference = (ServiceReference)referenceField.get(function);
                Object target = context.getService(reference);
                try {
                    if (target instanceof Function) {
                        function = (Function)target;
                    }
                }
                finally {
                    context.ungetService(reference);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return function;
    }
}

