/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Framework {
    private File base;
    private List<String> config;

    public Framework(File base) {
        this.base = base;
    }

    public abstract String getName();

    public abstract void enableDebug(File var1) throws IOException;

    public abstract void disableDebug(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfigProperties() throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new File(this.base, "etc/config.properties"));
            for (String line : this.getConfig()) {
                writer.printf("%s%n", line);
            }
            writer.flush();
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected List<String> readPropertyFile(File config) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(config));
        String line = reader.readLine();
        while (line != null) {
            result.add(line);
            line = reader.readLine();
        }
        return result;
    }

    protected void setConfigProperty(String key, String value) throws IOException {
        boolean done = false;
        for (int i = 0; i < this.getConfig().size(); ++i) {
            if (!this.getConfig().get(i).startsWith(key)) continue;
            this.getConfig().set(i, String.format("%s=%s", key, value));
            done = true;
        }
        if (!done) {
            this.getConfig().add("");
            this.getConfig().add(String.format("%s=%s", key, value, new Date()));
        }
    }

    protected void removeConfigProperty(String key) throws IOException {
        for (int i = 0; i < this.getConfig().size(); ++i) {
            if (!this.getConfig().get(i).startsWith(key)) continue;
            this.getConfig().remove(i);
        }
    }

    public List<String> getConfig() throws IOException {
        if (this.config == null) {
            this.config = this.readPropertyFile(new File(this.base, "etc/config.properties"));
        }
        return this.config;
    }
}

