/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.header;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.libg.generics.Create;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.service.reporter.Reporter;
import java.util.List;

public class OSGiHeader {
    public static Parameters parseHeader(String value) {
        return OSGiHeader.parseHeader(value, null);
    }

    public static Parameters parseHeader(String value, Reporter logger) {
        return OSGiHeader.parseHeader(value, logger, new Parameters());
    }

    public static Parameters parseHeader(String value, Reporter logger, Parameters result) {
        if (value == null || value.trim().length() == 0) {
            return result;
        }
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            Attrs clause = new Attrs(new Attrs[0]);
            List<String> aliases = Create.list();
            String name = qt.nextToken(",;");
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: " + value, new Object[0]);
                }
                if (name != null) continue;
                break;
            }
            name = name.trim();
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4", new Object[0]);
                    }
                    if (adname == null || adname.length() <= 0) continue;
                    aliases.add(adname.trim());
                    continue;
                }
                String advalue = qt.nextToken();
                if (clause.containsKey(adname) && logger != null && logger.isPedantic()) {
                    logger.warning("Duplicate attribute/directive name " + adname + " in " + value + ". This attribute/directive will be ignored", new Object[0]);
                }
                if (advalue == null) {
                    if (logger != null) {
                        logger.error("No value after '=' sign for attribute " + adname, new Object[0]);
                    }
                    advalue = "";
                }
                clause.put(adname.trim(), advalue.trim());
                del = qt.getSeparator();
                hadAttribute = true;
            }
            for (String clauseName : aliases) {
                if (result.containsKey(clauseName)) {
                    if (logger != null && logger.isPedantic()) {
                        logger.warning("Duplicate name " + clauseName + " used in header: '" + clauseName + "'. Duplicate names are specially marked in Bnd with a ~ at the end (which is stripped at printing time).", new Object[0]);
                    }
                    while (result.containsKey(clauseName)) {
                        clauseName = clauseName + "~";
                    }
                }
                result.put(clauseName, clause);
            }
        } while (del == ',');
        return result;
    }

    public static Attrs parseProperties(String input) {
        return OSGiHeader.parseProperties(input, null);
    }

    public static Attrs parseProperties(String input, Reporter logger) {
        if (input == null || input.trim().length() == 0) {
            return new Attrs(new Attrs[0]);
        }
        Attrs result = new Attrs(new Attrs[0]);
        QuotedTokenizer qt = new QuotedTokenizer(input, "=,");
        int del = 44;
        while (del == 44) {
            String key = qt.nextToken(",=");
            String value = "";
            del = qt.getSeparator();
            if (del == 61) {
                value = qt.nextToken(",=");
                del = qt.getSeparator();
            }
            result.put(key, value);
        }
        if (del != 0) {
            if (logger == null) {
                throw new IllegalArgumentException("Invalid syntax for properties: " + input);
            }
            logger.error("Invalid syntax for properties: " + input, new Object[0]);
        }
        return result;
    }
}

