/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.di;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.di.ValueRecipe;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;

public class MapRecipe
extends AbstractRecipe {
    private final List<Recipe[]> entries;
    private final Class<?> typeClass;
    private final Object keyType;
    private final Object valueType;

    public MapRecipe(String name, Class<?> type, Object keyType, Object valueType) {
        super(name);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.typeClass = type;
        this.entries = new ArrayList<Recipe[]>();
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.entries.size() * 2);
        for (Recipe[] entry : this.entries) {
            nestedRecipes.add(entry[0]);
            if (entry[1] == null) continue;
            nestedRecipes.add(entry[1]);
        }
        return nestedRecipes;
    }

    private ReifiedType getType(Object o) {
        ReifiedType type = o instanceof Class ? new ReifiedType((Class)o) : (o instanceof String ? this.loadType((String)o) : new ReifiedType(Object.class));
        return type;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        Map instance;
        Object o;
        Class<?> mapType = MapRecipe.getMap(this.typeClass);
        if (!ReflectionUtils.hasDefaultConstructor(mapType)) {
            throw new ComponentDefinitionException("Type does not have a default constructor " + mapType.getName());
        }
        try {
            o = mapType.newInstance();
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Error while creating set instance: " + mapType.getName());
        }
        if (o instanceof Map) {
            instance = (Map)o;
        } else if (o instanceof Dictionary) {
            instance = new DummyDictionaryAsMap((Dictionary)o);
        } else {
            throw new ComponentDefinitionException("Specified map type does not implement the Map interface: " + mapType.getName());
        }
        ReifiedType defaultConvertKeyType = this.getType(this.keyType);
        ReifiedType defaultConvertValueType = this.getType(this.valueType);
        try {
            for (Recipe[] entry : this.entries) {
                ReifiedType convertKeyType = this.workOutConversionType(entry[0], defaultConvertKeyType);
                Object key = this.convert(entry[0].create(), convertKeyType);
                ReifiedType convertValueType = this.workOutConversionType(entry[1], defaultConvertValueType);
                Object value = entry[1] != null ? this.convert(entry[1].create(), convertValueType) : null;
                instance.put(key, value);
            }
        }
        catch (Exception e) {
            throw new ComponentDefinitionException((Throwable)e);
        }
        return instance;
    }

    protected ReifiedType workOutConversionType(Recipe entry, ReifiedType defaultType) {
        if (entry instanceof ValueRecipe) {
            return this.getType(((ValueRecipe)entry).getValueType());
        }
        return defaultType;
    }

    public void put(Recipe key, Recipe value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.entries.add(new Recipe[]{key, value});
    }

    public void putAll(Map<Recipe, Recipe> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        for (Map.Entry<Recipe, Recipe> entry : map.entrySet()) {
            Recipe key = entry.getKey();
            Recipe value = entry.getValue();
            this.put(key, value);
        }
    }

    public static Class<?> getMap(Class<?> type) {
        if (ReflectionUtils.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedMap.class.isAssignableFrom(type)) {
            return TreeMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentHashMap.class;
        }
        return LinkedHashMap.class;
    }

    public static class DummyDictionaryAsMap
    extends AbstractMap {
        private final Dictionary dictionary;

        public DummyDictionaryAsMap(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public Object put(Object key, Object value) {
            return this.dictionary.put(key, value);
        }

        @Override
        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

