/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.graph.Graph;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AppLifeCycle
extends Graph {
    private static final Logger LOG = Log.getLogger(AppLifeCycle.class);
    private static final String ALL_NODES = "*";
    public static final String UNDEPLOYED = "undeployed";
    public static final String DEPLOYING = "deploying";
    public static final String DEPLOYED = "deployed";
    public static final String STARTING = "starting";
    public static final String STARTED = "started";
    public static final String STOPPING = "stopping";
    public static final String UNDEPLOYING = "undeploying";
    private Map<String, List<Binding>> lifecyclebindings = new HashMap<String, List<Binding>>();

    public AppLifeCycle() {
        this.addEdge(UNDEPLOYED, DEPLOYING);
        this.addEdge(DEPLOYING, DEPLOYED);
        this.addEdge(DEPLOYED, STARTING);
        this.addEdge(STARTING, STARTED);
        this.addEdge(STARTED, STOPPING);
        this.addEdge(STOPPING, DEPLOYED);
        this.addEdge(DEPLOYED, UNDEPLOYING);
        this.addEdge(UNDEPLOYING, UNDEPLOYED);
    }

    public void addBinding(Binding binding) {
        for (String nodeName : binding.getBindingTargets()) {
            List<Binding> bindings = this.lifecyclebindings.get(nodeName);
            if (bindings == null) {
                bindings = new ArrayList<Binding>();
            }
            bindings.add(binding);
            this.lifecyclebindings.put(nodeName, bindings);
        }
    }

    public void removeBinding(Binding binding) {
        for (String nodeName : binding.getBindingTargets()) {
            List<Binding> bindings = this.lifecyclebindings.get(nodeName);
            if (bindings == null) continue;
            bindings.remove(binding);
        }
    }

    public Set<Binding> getBindings() {
        HashSet<Binding> boundset = new HashSet<Binding>();
        for (List<Binding> bindings : this.lifecyclebindings.values()) {
            boundset.addAll(bindings);
        }
        return boundset;
    }

    public Set<Binding> getBindings(Node node) {
        return this.getBindings(node.getName());
    }

    public Set<Binding> getBindings(String nodeName) {
        HashSet<Binding> boundset = new HashSet<Binding>();
        List<Binding> bindings = this.lifecyclebindings.get(nodeName);
        if (bindings != null) {
            boundset.addAll(bindings);
        }
        if ((bindings = this.lifecyclebindings.get(ALL_NODES)) != null) {
            boundset.addAll(bindings);
        }
        return boundset;
    }

    public void runBindings(Node node, App app, DeploymentManager deploymentManager) throws Throwable {
        for (Binding binding : this.getBindings(node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calling " + binding.getClass().getName() + " for " + app, new Object[0]);
            }
            binding.processBinding(node, app);
        }
    }

    public static interface Binding {
        public String[] getBindingTargets();

        public void processBinding(Node var1, App var2) throws Exception;
    }
}

