/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreIsLocked;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiKeystoreManager
implements KeystoreManager {
    private static final transient Logger logger = LoggerFactory.getLogger(OsgiKeystoreManager.class);
    private List<KeystoreInstance> keystores = new CopyOnWriteArrayIdentityList<KeystoreInstance>();

    public void register(KeystoreInstance keystore, Map<String, ?> properties) {
        this.keystores.add(keystore);
    }

    public void unregister(KeystoreInstance keystore, Map<String, ?> properties) {
        this.keystores.remove(keystore);
    }

    @Override
    public KeystoreInstance getKeystore(String name) {
        KeystoreInstance keystore = null;
        for (KeystoreInstance ks : this.keystores) {
            if (!ks.getName().equals(name) || keystore != null && keystore.getRank() >= ks.getRank()) continue;
            keystore = ks;
        }
        return keystore;
    }

    @Override
    public SSLContext createSSLContext(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        return this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore, 0L);
    }

    @Override
    public SSLContext createSSLContext(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, long timeout) throws GeneralSecurityException {
        KeystoreInstance trustInstance;
        if (!this.checkForKeystoresAvailability(keyStore, keyAlias, trustStore, timeout)) {
            throw new GeneralSecurityException("Unable to lookup configured keystore and/or truststore");
        }
        KeystoreInstance keyInstance = this.getKeystore(keyStore);
        if (keyInstance != null && keyInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked");
        }
        if (keyInstance != null && keyInstance.isKeyLocked(keyAlias)) {
            throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked");
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked");
        }
        SSLContext context = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        context.init(keyInstance == null ? null : keyInstance.getKeyManager(algorithm, keyAlias), trustInstance == null ? null : trustInstance.getTrustManager(algorithm), new SecureRandom());
        return context;
    }

    @Override
    public SSLServerSocketFactory createSSLServerFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        return this.createSSLServerFactory(provider, protocol, algorithm, keyStore, keyAlias, trustStore, 0L);
    }

    @Override
    public SSLServerSocketFactory createSSLServerFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, long timeout) throws GeneralSecurityException {
        SSLContext context = this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore, timeout);
        return context.getServerSocketFactory();
    }

    @Override
    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        return this.createSSLFactory(provider, protocol, algorithm, keyStore, keyAlias, trustStore, 0L);
    }

    @Override
    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, long timeout) throws GeneralSecurityException {
        SSLContext context = this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore, timeout);
        return context.getSocketFactory();
    }

    private boolean checkForKeystoresAvailability(String keyStore, String keyAlias, String trustStore, long timeout) throws GeneralSecurityException {
        long start = System.currentTimeMillis();
        while (true) {
            KeystoreInstance trustInstance;
            KeystoreInstance keyInstance = this.getKeystore(keyStore);
            KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore);
            if (keyStore != null && keyInstance == null) {
                logger.info("Keystore {} not found", (Object)keyStore);
            } else if (keyStore != null && keyInstance.isKeystoreLocked()) {
                logger.info("Keystore {} locked", (Object)keyStore);
            } else if (keyStore != null && keyAlias != null && keyInstance.isKeyLocked(keyAlias)) {
                logger.info("Keystore's key {} locked", (Object)keyAlias);
            } else if (trustStore != null && trustInstance == null) {
                logger.info("Truststore {} not found", (Object)trustStore);
            } else if (trustStore != null && trustInstance.isKeystoreLocked()) {
                logger.info("Truststore {} locked", (Object)keyStore);
            } else {
                return true;
            }
            if (System.currentTimeMillis() - start >= timeout) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new GeneralSecurityException("Interrupted", e);
            }
        }
        return false;
    }
}

