/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.framework.ServiceState;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.apache.aries.jmx.util.shared.RegistrableStandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceStateMBeanHandler
implements MBeanHandler {
    private JMXAgentContext agentContext;
    private String name;
    private StandardMBean mbean;
    private ServiceState serviceStateMBean;
    private BundleContext bundleContext;
    private Logger logger;

    public ServiceStateMBeanHandler(JMXAgentContext agentContext) {
        this.agentContext = agentContext;
        this.bundleContext = agentContext.getBundleContext();
        this.logger = agentContext.getLogger();
        this.name = ObjectNameUtils.createFullObjectName(this.bundleContext, "osgi.core:type=serviceState,version=1.7");
    }

    @Override
    public void open() {
        this.serviceStateMBean = new ServiceState(this.bundleContext, this.logger);
        try {
            this.mbean = new RegistrableStandardEmitterMBean(this.serviceStateMBean, ServiceStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(1, "Failed to instantiate MBean for " + ServiceStateMBean.class.getName(), e);
        }
        this.agentContext.registerMBean(this);
    }

    @Override
    public StandardMBean getMbean() {
        return this.mbean;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.agentContext.unregisterMBean(this);
        if (this.serviceStateMBean != null) {
            this.serviceStateMBean.shutDownDispatcher();
        }
    }
}

