/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.interfaces;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.FinalModifierException;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.interfaces.ProxyClassLoader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.osgi.framework.Bundle;

public final class InterfaceProxyGenerator
extends ClassVisitor
implements Opcodes {
    private static final Map<Bundle, WeakReference<ProxyClassLoader>> cache = new WeakHashMap<Bundle, WeakReference<ProxyClassLoader>>(128);

    public InterfaceProxyGenerator() {
        super(262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getProxyInstance(Bundle client, Class<?> superclass, Collection<Class<?>> ifaces, Callable<Object> dispatcher, InvocationListener listener) throws UnableToProxyException {
        if (superclass != null && (superclass.getModifiers() & 0x10) != 0) {
            throw new FinalModifierException(superclass);
        }
        ProxyClassLoader pcl = null;
        SortedSet<Class<?>> interfaces = InterfaceProxyGenerator.createSet(ifaces);
        Map<Bundle, WeakReference<ProxyClassLoader>> map = cache;
        synchronized (map) {
            WeakReference<ProxyClassLoader> ref = cache.get(client);
            if (ref != null) {
                pcl = (ProxyClassLoader)ref.get();
            }
            if (pcl != null && pcl.isInvalid(interfaces)) {
                pcl = null;
                cache.remove(client);
            }
            if (pcl == null) {
                pcl = new ProxyClassLoader(client);
                cache.put(client, new WeakReference<ProxyClassLoader>(pcl));
            }
        }
        Class<?> c = pcl.createProxyClass(superclass, interfaces);
        try {
            Constructor<?> con = c.getDeclaredConstructor(Callable.class, InvocationListener.class);
            con.setAccessible(true);
            return con.newInstance(dispatcher, listener);
        }
        catch (Exception e) {
            throw new UnableToProxyException(ifaces.iterator().next(), (Throwable)e);
        }
    }

    private static SortedSet<Class<?>> createSet(Collection<Class<?>> ifaces) {
        TreeSet classes = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> object1, Class<?> object2) {
                return object1.getName().compareTo(object2.getName());
            }
        });
        for (Class<?> c : ifaces) {
            if (!classes.add(c)) continue;
            classes.addAll(InterfaceProxyGenerator.createSet(Arrays.asList(c.getInterfaces())));
        }
        return classes;
    }
}

