/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core;

import java.io.File;
import java.util.ArrayList;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.apache.karaf.diagnostic.core.common.DirectoryDumpDestination;
import org.apache.karaf.diagnostic.core.common.ZipDumpDestination;
import org.apache.karaf.diagnostic.core.providers.BundleDumpProvider;
import org.apache.karaf.diagnostic.core.providers.EnvironmentDumpProvider;
import org.apache.karaf.diagnostic.core.providers.HeapDumpProvider;
import org.apache.karaf.diagnostic.core.providers.MemoryDumpProvider;
import org.apache.karaf.diagnostic.core.providers.ThreadDumpProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class Dump {
    public static DumpDestination directory(File file) {
        return new DirectoryDumpDestination(file);
    }

    public static DumpDestination zip(File file) {
        return new ZipDumpDestination(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(BundleContext bundleContext, DumpDestination destination) {
        ArrayList<DumpProvider> providers = new ArrayList<DumpProvider>();
        providers.add(new EnvironmentDumpProvider(bundleContext));
        providers.add(new MemoryDumpProvider());
        providers.add(new ThreadDumpProvider());
        providers.add(new HeapDumpProvider());
        providers.add(new BundleDumpProvider(bundleContext));
        for (DumpProvider provider : providers) {
            try {
                provider.createDump(destination);
            }
            catch (Throwable t) {}
        }
        try {
            for (ServiceReference ref : bundleContext.getServiceReferences(DumpProvider.class, null)) {
                DumpProvider provider = (DumpProvider)bundleContext.getService(ref);
                try {
                    provider.createDump(destination);
                }
                catch (Throwable t) {}
                continue;
                finally {
                    bundleContext.ungetService(ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        try {
            destination.save();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("Created dump " + destination.toString());
    }

    private Dump() {
    }
}

