/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private BundleRevision m_bundleRevision;
    private Long m_bundleId;
    private String m_bundleSymbolicName;
    private String m_bundleVersion;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            for (Object o : context.keySet()) {
                String key = (String)o;
                Object value = context.get(key);
                MDC.put(key, value);
            }
        }
        if (this.m_bundle != null) {
            BundleRevision rev = (BundleRevision)this.m_bundle.adapt(BundleRevision.class);
            if (rev != this.m_bundleRevision) {
                this.m_bundleId = this.m_bundle.getBundleId();
                this.m_bundleSymbolicName = this.m_bundle.getSymbolicName();
                this.m_bundleVersion = this.m_bundle.getVersion().toString();
                this.m_bundleRevision = rev;
            }
            this.put("bundle.id", this.m_bundleId);
            this.put("bundle.name", this.m_bundleSymbolicName);
            this.put("bundle.version", this.m_bundleVersion);
        }
        this.m_service.getConfigLock().readLock().lock();
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        this.m_service.getConfigLock().readLock().unlock();
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.TRACE, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.DEBUG, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.INFO, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.WARN, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.ERROR, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(this.m_fqcn, Level.FATAL, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.TRACE, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.DEBUG, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.INFO, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.WARN, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.ERROR, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.setDelegateContext();
            try {
                this.m_delegate.log(fqcn, Level.FATAL, message, t);
            }
            finally {
                this.clearDelegateContext();
            }
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    public int getLogLevel() {
        Level level = this.m_delegate.getEffectiveLevel();
        if (level == null) {
            return 4;
        }
        if (Level.TRACE.isGreaterOrEqual(level)) {
            return 0;
        }
        if (Level.DEBUG.isGreaterOrEqual(level)) {
            return 1;
        }
        if (Level.INFO.isGreaterOrEqual(level)) {
            return 2;
        }
        if (Level.WARN.isGreaterOrEqual(level)) {
            return 3;
        }
        return 4;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Priority level, Object message, Throwable t) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(this.m_fqcn, level, message, t);
        }
        finally {
            this.clearDelegateContext();
        }
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

