/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIoServiceFactoryFactory
implements IoServiceFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactoryFactory.class);
    private IoServiceFactoryFactory factory;

    @Override
    public IoServiceFactory create(FactoryManager manager) {
        return this.getFactory().create(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoServiceFactoryFactory getFactory() {
        DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = this;
        synchronized (defaultIoServiceFactoryFactory) {
            if (this.factory == null) {
                this.factory = DefaultIoServiceFactoryFactory.newInstance(IoServiceFactoryFactory.class);
            }
        }
        return this.factory;
    }

    private static <T> T newInstance(Class<T> clazz) {
        T t;
        String factory = System.getProperty(clazz.getName());
        if (factory != null) {
            return DefaultIoServiceFactoryFactory.newInstance(clazz, factory);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (t = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, cl))) != null) {
            return t;
        }
        if (cl != DefaultIoServiceFactoryFactory.class.getClassLoader() && (t = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, DefaultIoServiceFactoryFactory.class.getClassLoader()))) != null) {
            return t;
        }
        throw new IllegalStateException("Could not find a valid sshd io provider");
    }

    private static <T> T tryLoad(ServiceLoader<T> loader) {
        Iterator<T> it = loader.iterator();
        try {
            while (it.hasNext()) {
                try {
                    return it.next();
                }
                catch (Throwable t) {
                    LOGGER.trace("Exception while loading factory from ServiceLoader", t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.trace("Exception while loading factory from ServiceLoader", t);
        }
        return null;
    }

    private static <T> T newInstance(Class<T> clazz, String factory) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return clazz.cast(cl.loadClass(factory).newInstance());
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        if (cl != DefaultIoServiceFactoryFactory.class.getClassLoader()) {
            try {
                return clazz.cast(DefaultIoServiceFactoryFactory.class.getClassLoader().loadClass(factory).newInstance());
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + factory);
    }
}

