/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.dev.AbstractBundleCommand;
import org.apache.karaf.shell.dev.util.Bundles;
import org.apache.karaf.shell.dev.util.Import;
import org.apache.karaf.shell.dev.util.Node;
import org.apache.karaf.shell.dev.util.Tree;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="dev", name="show-tree", description="Shows the tree of bundles based on the wiring information.")
public class ShowBundleTree
extends AbstractBundleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowBundleTree.class);
    private Tree<Bundle> tree;

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        long start = System.currentTimeMillis();
        this.printHeader(bundle);
        this.tree = new Tree<Bundle>(bundle);
        this.createTree(bundle);
        this.printTree(this.tree);
        this.printDuplicatePackages(this.tree);
        LOGGER.debug(String.format("Dependency tree calculated in %d ms", System.currentTimeMillis() - start));
    }

    private void printHeader(Bundle bundle) {
        System.out.printf("Bundle %s [%s] is currently %s%n", bundle.getSymbolicName(), bundle.getBundleId(), Bundles.toString(bundle.getState()));
    }

    private void printTree(Tree<Bundle> tree) {
        System.out.printf("%n", new Object[0]);
        tree.write(System.out, new Tree.Converter<Bundle>(){

            @Override
            public String toString(Node<Bundle> node) {
                return String.format("%s [%s]", node.getValue().getSymbolicName(), node.getValue().getBundleId());
            }
        });
    }

    private void printDuplicatePackages(Tree<Bundle> tree) {
        Set bundles = tree.flatten();
        HashMap exports = new HashMap();
        for (Bundle bundle : bundles) {
            ExportedPackage[] packages = this.getPackageAdmin().getExportedPackages(bundle);
            if (packages == null) continue;
            for (ExportedPackage p : packages) {
                if (exports.get(p.getName()) == null) {
                    exports.put(p.getName(), new HashSet());
                }
                ((Set)exports.get(p.getName())).add(bundle);
            }
        }
        for (String pkg : exports.keySet()) {
            if (((Set)exports.get(pkg)).size() <= 1) continue;
            System.out.printf("%n", new Object[0]);
            System.out.printf("WARNING: multiple bundles are exporting package %s%n", pkg);
            for (Bundle bundle : (Set)exports.get(pkg)) {
                System.out.printf("- %s%n", bundle);
            }
        }
    }

    protected void createTree(Bundle bundle) {
        if (bundle.getState() >= 4) {
            this.createNode(this.tree);
        } else {
            this.createNodesForImports(this.tree, bundle);
        }
    }

    private void createNodesForImports(Node node, Bundle bundle) {
        for (Import i : Import.parse(String.valueOf(bundle.getHeaders().get("Import-Package")), String.valueOf(bundle.getHeaders().get("Export-Package")))) {
            this.createNodeForImport(node, bundle, i);
        }
    }

    private void createNodeForImport(Node node, Bundle bundle, Import i) {
        ExportedPackage[] exporters = this.getPackageAdmin().getExportedPackages(i.getPackage());
        boolean foundMatch = false;
        if (exporters != null) {
            for (ExportedPackage ep : exporters) {
                if (!i.getVersion().contains(ep.getVersion())) continue;
                if (bundle.equals(ep.getExportingBundle())) {
                    foundMatch = true;
                    continue;
                }
                Node child = node.addChild(ep.getExportingBundle());
                System.out.printf("- import %s: resolved using %s%n", i, ep.getExportingBundle());
                foundMatch = true;
                this.createNode(child);
            }
        }
        if (!foundMatch) {
            System.out.printf("- import %s: WARNING - unable to find matching export%n", i);
        }
    }

    private void createNode(Node<Bundle> node) {
        Bundle bundle = node.getValue();
        HashSet<Bundle> exporters = new HashSet<Bundle>();
        exporters.addAll(this.getWiredBundles(bundle).values());
        for (Bundle exporter : exporters) {
            if (node.hasAncestor(exporter)) {
                LOGGER.debug(String.format("Skipping %s (already exists in the current branch)", exporter));
                continue;
            }
            boolean existing = this.tree.flatten().contains(exporter);
            LOGGER.debug(String.format("Adding %s as a dependency for %s", exporter, bundle));
            Node child = node.addChild(exporter);
            if (existing) {
                LOGGER.debug(String.format("Skipping children of %s (already exists in another branch)", exporter));
                continue;
            }
            this.createNode(child);
        }
    }
}

